DESCRIPTION="PulseAudio is a sound system for POSIX OSes, meaning that it is a proxy for sound applications."
# PulseAudio
# PulseAudio is a sound system for POSIX OSes, meaning that it is a proxy for sound applications. It allows you to do advanced operations on your sound data as it passes between your application and your hardware. Operations such as transferring the audio to a different machine, changing the sample format or channel count, and mixing several sounds into one are easily achieved using a sound server. 

# Contents
# Installed Programs: pacat, pacmd, pactl, padsp, pamon (symlink to pacat), paplay (symlink to pacat), parec (symlink to pacat), parecord (symlink to pacat), qpaeq, pasuspender, pax11publish, pulseaudio, and start-pulseaudio-x11
# Installed Libraries: libpulse.so, libpulse-mainloop-glib.so, libpulse-simple.so, libpulsecommon-17.0.so, libpulsecore-17.0.so, and libpulsedsp.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /etc/pulse, /usr/include/pulse, /usr/lib/cmake/PulseAudio, /usr/lib/{pulseaudio,pulse-17.0}, /usr/libexec/pulse, and /usr/share/pulseaudio

# Short Descriptions
# pacat - plays back or records raw or encoded audio streams on a PulseAudio sound server
# pacmd - is a tool used to reconfigure a PulseAudio sound server during runtime
# pactl - is used to control a running PulseAudio sound server
# padsp - is the PulseAudio OSS Wrapper
# pamon - is a symbolic link to pacat
# paplay - is used to play audio files on a PulseAudio sound server
# parec - is a symbolic link to pacat
# parecord - is a symbolic link to pacat
# pasuspender - is a tool that can be used to tell a local PulseAudio sound server to temporarily suspend access to the audio devices, which allows other applications to access them directly
# pax11publish - is the PulseAudio X11 Credential Utility
# pa-info - is a shell script that prints various information relating to the Pulseaudio server currently in use
# pulseaudio - is a networked low-latency sound server for Linux
# qpaeq - is an equalizer interface for PulseAudio equalizer sinks (Requires fftw-3.3.10 at build time)
# start-pulseaudio-x11 - starts PulseAudio and registers it to the X11 session manager

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_PULSEAUDIO .tar.xz | cut -d "-" -f 2) 

mkdir build &&
cd    build &&

meson setup --prefix=/usr       \
            --buildtype=release \
            -D database=gdbm    \
            -D doxygen=false    \
            -D bluez5=disabled  \
            ..                  &&
ninja

# As root:
ninja install

rm /usr/share/dbus-1/system.d/pulseaudio-system.conf

if $MULTILIB
then
	rm -rf *
	meson setup --cross-file=lib32  \
				--prefix=/usr       \
				--libdir=/usr/lib32 \
				--buildtype=release \
				-D database=gdbm    \
				-D doxygen=false    \
				-D bluez5=disabled  \
				-D tests=false      \
				.. 

	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	rm -rf *
	meson setup --cross-file=libx32  \
				--prefix=/usr       \
				--libdir=/usr/libx32 \
				--buildtype=release \
				-D database=gdbm    \
				-D doxygen=false    \
				-D bluez5=disabled  \
				-D tests=false      \
				.. 

	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 
	ldconfig	
fi

update_version_list $PKG_PULSEAUDIO
