DESCRIPTION="PostgreSQL is an advanced object-relational database management system (ORDBMS), derived from the Berkeley Postgres database management system."

EXT_VERSION=$(basename $PKG_POSTGRESQL .tar.bz2 | cut -d "-" -f 2) 

[[ $(cat /etc/group | grep postgres) == "" ]] && groupadd -g 41 postgres
[[ $(cat /etc/passwd | grep postgres:) == "" ]] && useradd -c "PostgreSQL Server" -g postgres -d /srv/pgsql/data -u 41 postgres

sed -i '/DEFAULT_PGSOCKET_DIR/s@/tmp@/run/postgresql@' src/include/pg_config_manual.h

# --with-openssl: builds the package with support for OpenSSL encrypted connections.
# --with-perl: builds the PL/Perl server-side language.
# --with-python: builds the PL/Python server-side language.
# --with-tcl: builds the PL/Tcl server-side language.

OPTIONS="" #ICU

./configure --prefix=/usr	\
			--with-perl		\
			--with-python	\
			--with-tcl		\
			--with-openssl	\
			$OPTIONS		\
            --docdir=/usr/share/doc/postgresql-$EXT_VERSION
make

if [ -f /usr/lib/systemd/system/postgresql.service ]; then
	make DESTDIR=$(pwd)/DESTDIR install
	install -d -o postgres $(pwd)/DESTDIR/tmp

	pushd $(pwd)/DESTDIR/tmp
	systemctl stop postgresql
	[ ! -d /srv/pgsql ] && mkdir /srv/pgsql
	chown -R postgres:postgres /srv/pgsql
	su postgres -c "../usr/bin/initdb -D /srv/pgsql/newdata"
	if [ -f /srv/pgsql/data/PG_VERSION ]; then
		su postgres -c "../usr/bin/pg_upgrade \
							-d /srv/pgsql/data    -b /usr/bin \
							-D /srv/pgsql/newdata -B ../usr/bin"
	fi
	popd

	[ -d /srv/pgsql/data ] && rm -rf /srv/pgsql/data
	[ -d /srv/pgsql/newdata ] && mv /srv/pgsql/newdata /srv/pgsql/data
fi

# As root:
make install 
make install-docs

if [ ! -f /usr/lib/systemd/system/postgresql.service ]; then
	pushd /etc/extension/startupfiles
		make install-postgresql
	popd
fi
#postgres -c '/usr/bin/postgres -D /srv/pgsql/data > /srv/pgsql/data/logfile 2>&1 &'

#make -C contrib/<SUBDIR-NAME> install

update_version_list $PKG_POSTGRESQL
