DESCRIPTION="The Poppler package contains a PDF rendering library and command line tools used to manipulate PDF files."

EXT_VERSION=$(basename $PKG_POPPLER .tar.xz | cut -d "-" -f 2) 

OPTIONS=""
[[ $(command -v gtkdocize) != "" ]] && OPTIONS="$OPTIONS -D ENABLE_GTK_DOC=ON"
[ ! -f /lib/libboost_atomic.so ] && OPTIONS="$OPTIONS -D ENABLE_BOOST=OFF"
[[ $(command -v qmake) == "" ]] && OPTIONS="$OPTIONS -D ENABLE_QT6=OFF"
[[ $(command -v nss-config) == "" ]] && OPTIONS="$OPTIONS -D ENABLE_NSS3=OFF"
[[ $(command -v gpgme-tool) == "" ]] && OPTIONS="$OPTIONS -D ENABLE_GPGME=OFF"
[[ $(command -v tiffinfo) == "" ]] && OPTIONS="$OPTIONS -D ENABLE_LIBTIFF=OFF"

mkdir build
cd    build

cmake -D CMAKE_BUILD_TYPE=Release   \
      -D CMAKE_INSTALL_PREFIX=/usr  \
      -D TESTDATADIR=$PWD/testfiles \
      -D ENABLE_QT5=OFF             \
      -D ENABLE_UNSTABLE_API_ABI_HEADERS=ON \
      $OPTIONS -G Ninja .. 
ninja

# As root:
ninja install

install -v -m755 -d           /usr/share/doc/poppler-$EXT_VERSION
cp -vr ../glib/reference/html /usr/share/doc/poppler-$EXT_VERSION

[ -f ../../$(basename $DAT_POPPLER) ] && tar -xf ../../$(basename $DAT_POPPLER)
cd $(basename $DAT_POPPLER .tar.gz)

make prefix=/usr install

update_version_list $PKG_POPPLER
