DESCRIPTION="Polkit is a toolkit for defining and handling authorizations."
# Polkit
# Polkit is a toolkit for defining and handling authorizations. It is used for allowing unprivileged processes to communicate with privileged processes. 

# Contents
# Installed Programs: pkaction, pkcheck, pkexec, pkttyagent, and polkitd
# Installed Libraries: libpolkit-agent-1.so and libpolkit-gobject-1.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /etc/polkit-1, /usr/include/polkit-1, /usr/lib/polkit-1, /usr/share/gtk-doc/html/polkit-1, and /usr/share/polkit-1

# Short Descriptions
# pkaction - is used to obtain information about registered PolicyKit actions
# pkcheck - is used to check whether a process is authorized for action
# pkexec - allows an authorized user to execute a command as another user
# pkttyagent - is used to start a textual authentication agent for the subject
# polkitd - provides the org.freedesktop.PolicyKit1 D-Bus service on the system message bus
# libpolkit-agent-1.so - contains the Polkit authentication agent API functions
# libpolkit-gobject-1.so - contains the Polkit authorization API functions

# Required
# duktape-2.7.0 and GLib-2.82.5 (GObject Introspection recommended)

# Recommended
# libxslt-1.1.42, and Linux-PAM-1.7.0

# Recommended_Runtime
# Systemd-257.3

# Optional
# One polkit authentication agent for using polkit in the graphical environment: polkit-kde-agent in Plasma-6.3.2 for KDE, the agent built in gnome-shell-47.4 for GNOME3, polkit-gnome-0.105 for XFCE, and lxqt-policykit-2.1.0 for LXQt

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# GTK-Doc-1.34.0

# Optional_Testing
# dbusmock-0.34.3

EXT_VERSION=$(basename $PKG_POLKIT .tar.gz | cut -d "-" -f 2) 

# General setup --->
  # -*- Namespaces support --->                                       [NAMESPACES]
    # [*] User namespace                                                 [USER_NS]

[[ $(cat /etc/group | grep polkitd:) == "" ]] && groupadd -fg 27 polkitd
[[ $(cat /etc/passwd | grep polkitd:) == "" ]] && useradd -c "PolicyKit Daemon Owner" -d /etc/polkit-1 -u 27 -g polkitd -s /bin/false polkitd

mkdir build
cd    build

#source /etc/os-release
#	  -D gtk_doc=true			\

meson setup ..                   \
      --prefix=/usr              \
      --buildtype=release        \
      -D man=true                \
      -D session_tracking=logind \
      -D tests=false			\
	  -D os_type=lfs		#Possible choices are (as string): "redhat", "suse", "gentoo", "pardus", "solaris", "netbsd", "lfs", "openembedded", "debian", "".                                                                                                                                                          "gentoo", "pardus", "solaris", "netbsd", "lfs", "openembedded", "debian", "".

ninja

# As root:
ninja install

update_version_list $PKG_POLKIT
