DESCRIPTION="The pkgconf compilation in the multilib mirror does not cover pkgconf personalities which are needed for Meson Toolchain Files."

EXT_VERSION=12.3

mkdir -pv /usr/share/pkgconfig/personality.d &&

cat > /usr/share/pkgconfig/personality.d/x86_64-pc-linux-gnu.personality << "EOF" &&
Triplet: x86_64-pc-linux-gnu
SysrootDir: /
DefaultSearchPaths: /usr/lib/pkgconfig:/usr/share/pkgconfig
SystemIncludePaths: /usr/include
SystemLibraryPaths: /usr/lib
EOF

cat > /usr/share/pkgconfig/personality.d/x86_64-pc-linux-gnux32.personality << "EOF" &&
Triplet: x86_64-pc-linux-gnux32
SysrootDir: /
DefaultSearchPaths: /usr/libx32/pkgconfig:/usr/share/pkgconfig
SystemIncludePaths: /usr/include
SystemLibraryPaths: /usr/libx32
EOF

cat > /usr/share/pkgconfig/personality.d/i686-pc-linux-gnu.personality << "EOF"
Triplet: i686-pc-linux-gnu
SysrootDir: /
DefaultSearchPaths: /usr/lib32/pkgconfig:/usr/share/pkgconfig
SystemIncludePaths: /usr/include
SystemLibraryPaths: /usr/lib32
EOF

# As root:
[ ! -h /usr/bin/x86_64-pc-linux-gnu-pkg-config ] && ln -sv pkgconf /usr/bin/x86_64-pc-linux-gnu-pkg-config
[ ! -h /usr/bin/x86_64-pc-linux-gnux32-pkg-config ] && ln -sv pkgconf /usr/bin/x86_64-pc-linux-gnux32-pkg-config
[ ! -h /usr/bin/i686-pc-linux-gnu-pkg-config ] && ln -sv pkgconf /usr/bin/i686-pc-linux-gnu-pkg-config

#x86_64-pc-linux-gnu-pkg-config --dump-personality

	# Triplet: x86_64-pc-linux-gnu
	# SysrootDir: /
	# DefaultSearchPaths: /usr/lib/pkgconfig /usr/share/pkgconfig
	# SystemIncludePaths: /usr/include
	# SystemLibraryPaths: /usr/lib

#x86_64-pc-linux-gnux32-pkg-config --dump-personality

	# Triplet: x86_64-pc-linux-gnu
	# SysrootDir: /
	# DefaultSearchPaths: /usr/libx32/pkgconfig /usr/share/pkgconfig
	# SystemIncludePaths: /usr/include
	# SystemLibraryPaths: /usr/libx32

#i686-pc-linux-gnu-pkg-config --dump-personality

	# Triplet: i686-pc-linux-gnu
	# SysrootDir: /
	# DefaultSearchPaths: /usr/lib32/pkgconfig /usr/share/pkgconfig
	# SystemIncludePaths: /usr/include
	# SystemLibraryPaths: /usr/lib32

update_version_list pkgconf_personalties-$EXT_VERSION
