DESCRIPTION="The Parted package is a disk partitioning and partition resizing tool."

EXT_VERSION=$(basename $PKG_PARTED .tar.xz | cut -d "-" -f 2) 

./configure --prefix=/usr --disable-static
make &&

make -C doc html
makeinfo --html      -o doc/html       doc/parted.texi
makeinfo --plaintext -o doc/parted.txt doc/parted.texi

if [[ $(command -v texdoc) != "" ]]; then
	cp build-aux/texinfo.tex doc
	texi2pdf -o doc/parted.pdf doc/parted.texi
	texi2dvi -o doc/parted.dvi doc/parted.texi
	dvips    -o doc/parted.ps  doc/parted.dvi
fi

# As root:
make install &&
install -v -m755 -d /usr/share/doc/parted-${EXT_VERSION}/html
install -v -m644    doc/html/* \
                    /usr/share/doc/parted-${EXT_VERSION}/html
install -v -m644    doc/{FAT,API,parted.{txt,html}} \
                    /usr/share/doc/parted-$EXT_VERSION

install -v -m644 doc/FAT doc/API doc/parted.{pdf,ps,dvi} \
                    /usr/share/doc/parted-$EXT_VERSION

update_version_list $PKG_PARTED
