DESCRIPTION="Pango is a library for laying out and rendering text, with an emphasis on internationalization."
# Pango
# Pango is a library for laying out and rendering text, with an emphasis on internationalization. It can be used anywhere that text layout is needed, though most of the work on Pango so far has been done in the context of the GTK+ widget toolkit. 

# Contents
# Installed Programs: None
# Installed Libraries: None
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: None

# Short Descriptions
# pango-list - displays a list of fonts that Pango can use that are currently installed on the system
# pango-segmentation - shows text segmentation as determined by Pango.
# pango-view - renders a given text file through Pango for viewing purposes
# libpango-1.0.so - contains low level layout rendering routines, a high level driver for laying out entire blocks of text, and routines to assist in editing internationalized text

# Required
# Fontconfig-2.16.0 (must be built with FreeType-2.13.3 using harfBuzz-10.4.0), FriBidi-1.0.16, and GLib-2.82.5 (GObject Introspection required for GNOME)

# Recommended
# Cairo-1.18.2 (built after harfBuzz-10.4.0) and Xorg Libraries

# Recommended_Runtime
# None

# Optional
# Gi-DocGen-2025.3 (to generate documentation), help2man, libthai, and sysprof

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_PANGO .tar.xz | cut -d "-" -f 2) 

mkdir build &&
cd    build &&

meson setup --prefix=/usr            \
            --buildtype=release      \
            --wrap-mode=nofallback   \
            -D introspection=enabled \
            ..                       &&
ninja

if [[ $(command -v rst2html5) != "" ]]; then
	sed "/docs_dir =/s@\$@ / 'pango-${EXT_VERSION}'@" -i ../docs/meson.build &&
	meson configure -D documentation=true                            &&
	ninja
fi

# As root:
ninja install

update_version_list $PKG_PANGO
