DESCRIPTION="The p11-kit package provides a way to load and enumerate PKCS 11 (a Cryptographic Token Interface Standard) modules."
# GLib

# The GLib package contains low-level libraries useful for providing data structure handling for C, portability wrappers and interfaces for such 
#runtime functionality as an event loop, threads, dynamic loading and an object system.

# Contents
# Installed Programs: p11-kit, trust, and update-ca-certificates
# Installed Libraries: libp11-kit.so and p11-kit-proxy.so
# Installed Directories: /etc/pkcs11, /usr/include/p11-kit-1, /usr/lib/pkcs11, /usr/libexec/p11-kit, /usr/share/gtk-doc/html/p11-kit, and /usr/share/p11-kit

# Short Descriptions
# 
# p11-kit - is a command line tool that can be used to perform operations on PKCS#11 modules configured on the system
# trust - is a command line tool to examine and modify the shared trust policy store
# update-ca-certificates - is a command line tool to both extract local certificates from an updated anchor store, and regenerate all anchors and certificate stores on the system. This is done unconditionally on BLFS using the --force and --get flags to make-ca and should likely not be used for automated updates
# libp11-kit.so - contains functions used to coordinate initialization and finalization of any PKCS#11 module
# p11-kit-proxy.so - is the PKCS#11 proxy module

#VERSION_EXT=$(basename $PKG_P11_KIT .tar.?z* | cut -d "-" -f 2) 

sed '20,$ d' -i trust/trust-extract-compat &&

cat >> trust/trust-extract-compat << "EOF"
# Copy existing anchor modifications to /etc/ssl/local
/usr/libexec/make-ca/copy-trust-modifications

# Update trust stores
/usr/sbin/make-ca -r
EOF

mkdir p11-build
cd    p11-build

OPTIONALDOC=""
OPTIONALNSS=""
[[ $(command -v xsltproc) != "" ]] && [[ $(command -v gtkdocize) != "" ]] && OPTIONALDOC="-D gtk_doc=true"
#[[ $(command -v pk12util) != "" ]] && OPTIONALNSS="-D hash_impl=freebl"

meson setup ..            \
      --prefix=/usr       \
      --buildtype=release \
      -D trust_paths=/etc/pki/anchors \
	  $OPTIONALDOC $OPTIONALNSS
LC_ALL=C ninja

# As root:
[ -d /usr/bin/trust ] && rm -r /usr/bin/trust
ninja install
[ -h /usr/bin/update-ca-certificates ] && unlink /usr/bin/update-ca-certificates
ln -sfv /usr/libexec/p11-kit/trust-extract-compat \
        /usr/bin/update-ca-certificates

update_version_list $PKG_P11_KIT
