DESCRIPTION="Opus is a lossy audio compression format developed by the Internet Engineering Task Force."
# Opus
# Opus is a lossy audio compression format developed by the Internet Engineering Task Force (IETF) that is particularly suitable for interactive speech and audio transmission over the Internet. This package provides the Opus development library and headers. 

# Contents
# Installed Programs: None
# Installed Libraries: libopus.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/opus and /usr/share/doc/opus-1.5.2

# Short Descriptions
# libopus.so - provides the functions used to read and write Opus format

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# Doxygen-1.13.2 and texlive-20240312 (or install-tl-unx)

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_OPUS .tar.gz | cut -d "-" -f 2) 

mkdir build &&
cd    build &&

meson setup --prefix=/usr        \
            --buildtype=release  \
            -D docdir=/usr/share/doc/opus-$EXT_VERSION
ninja

# As root:
ninja install

if $MULTILIB
then
	rm -rf *
	CC="gcc -m32" CXX="g++ -m32"         	\
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig	\
	meson setup .. 							\
				--prefix=/usr 				\
				--libdir=/usr/lib32			\
				--buildtype=release
	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	rm -rf *
	CC="gcc -mx32" CXX="g++ -mx32"         		\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig		\
	meson setup .. 								\
				--prefix=/usr 					\
				--libdir=/usr/libx32			\
				--buildtype=release
	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 
	ldconfig	
fi

update_version_list $PKG_OPUS
