DESCRIPTION="OpenSSH package contains ssh clients and the sshd daemon"
# OpenSSH
# The OpenSSH package contains ssh clients and the sshd daemon. This is useful for encrypting authentication and subsequent traffic over a network. The ssh and scp commands are secure implementations of telnet and rcp respectively.

OPENSSH_VERSION=$(basename $PKG_OPENSSH .tar.xz | cut -d "-" -f 2)

install -v -g sys -m700 -d /var/lib/sshd

[ ! $(getent group sshd) ] && groupadd -g 50 sshd
[ ! $(id -Gn sshd) ] && useradd  -c 'sshd PrivSep' -d /var/lib/sshd -g sshd -s /bin/false -u 50 sshd

./configure --prefix=/usr                            \
            --sysconfdir=/etc/ssh                    \
            --with-privsep-path=/var/lib/sshd        \
            --with-default-path=/usr/bin             \
            --with-superuser-path=/usr/sbin:/usr/bin \
            --with-pid-dir=/run
# --sysconfdir=/etc/ssh: This prevents the configuration files from being installed in /usr/etc.
#--with-default-path=/usr/bin and --with-superuser-path=/usr/sbin:/usr/bin: These set PATH consistent with LFS and BLFS Shadow package.
#--with-pid-dir=/run: This prevents OpenSSH from referring to deprecated /var/run.
#--with-pam: This parameter enables Linux-PAM support in the build.
#--with-xauth=$XORG_PREFIX/bin/xauth: Set the default location for the xauth binary for X authentication. The environment variable XORG_PREFIX should be set following Xorg build environment. This can also be controlled from sshd_config with the XAuthLocation keyword. You can omit this switch if Xorg is already installed.
#--with-kerberos5=/usr: This option is used to include Kerberos 5 support in the build.
#--with-libedit: This option enables line editing and history features for sftp.

make

if $RUN_TESTS
then
    set +e
    make -j1 tests
    set -e
fi

make install

install -v -m755    contrib/ssh-copy-id /usr/bin
install -v -m644    contrib/ssh-copy-id.1 \
                    /usr/share/man/man1
install -v -m755 -d /usr/share/doc/$OPENSSH_VERSION
install -v -m644    INSTALL LICENCE OVERVIEW README* \
                    /usr/share/doc/$OPENSSH_VERSION
# Configuring OpenSSH
if [ ! -f /etc/ssh/sshd_config ]; then
cat << EOF > /etc/ssh/sshd_config
# This is the sshd server system-wide configuration file.  See
# sshd_config(5) for more information.

# This sshd was compiled with PATH=/usr/local/bin:/usr/bin:/bin:/usr/games

# The strategy used for options in the default sshd_config shipped with
# OpenSSH is to specify options with their default value where
# possible, but leave them commented.  Uncommented options override the
# default value.

Include /etc/ssh/sshd_config.d/*.conf

#Port 22
#AddressFamily any
#ListenAddress 0.0.0.0
#ListenAddress ::

#HostKey /etc/ssh/ssh_host_rsa_key
#HostKey /etc/ssh/ssh_host_ecdsa_key
#HostKey /etc/ssh/ssh_host_ed25519_key

# Ciphers and keying
#RekeyLimit default none

# Logging
#SyslogFacility AUTH
#LogLevel INFO

# Authentication:

#LoginGraceTime 2m
#PermitRootLogin prohibit-password
#StrictModes yes
#MaxAuthTries 6
#MaxSessions 10

#PubkeyAuthentication yes

# Expect .ssh/authorized_keys2 to be disregarded by default in future.
#AuthorizedKeysFile     .ssh/authorized_keys .ssh/authorized_keys2

#AuthorizedPrincipalsFile none

#AuthorizedKeysCommand none
#AuthorizedKeysCommandUser nobody

# For this to work you will also need host keys in /etc/ssh/ssh_known_hosts
#HostbasedAuthentication no
# Change to yes if you don't trust ~/.ssh/known_hosts for
# HostbasedAuthentication
#IgnoreUserKnownHosts no
# Don't read the user's ~/.rhosts and ~/.shosts files
#IgnoreRhosts yes

# To disable tunneled clear text passwords, change to no here!
#PasswordAuthentication yes
#PermitEmptyPasswords no

# Change to yes to enable challenge-response passwords (beware issues with
# some PAM modules and threads)
KbdInteractiveAuthentication no

# Kerberos options
#KerberosAuthentication no
#KerberosOrLocalPasswd yes
#KerberosTicketCleanup yes
#KerberosGetAFSToken no

# GSSAPI options
#GSSAPIAuthentication no
#GSSAPICleanupCredentials yes
#GSSAPIStrictAcceptorCheck yes
#GSSAPIKeyExchange no

# Set this to 'yes' to enable PAM authentication, account processing,
# and session processing. If this is enabled, PAM authentication will
# be allowed through the KbdInteractiveAuthentication and
# PasswordAuthentication.  Depending on your PAM configuration,
# PAM authentication via KbdInteractiveAuthentication may bypass
# the setting of "PermitRootLogin prohibit-password".
# If you just want the PAM account and session checks to run without
# PAM authentication, then enable this but set PasswordAuthentication
# and KbdInteractiveAuthentication to 'no'.
EOF
if [ -d /etc/pam.d]; then
	sed 's@d/login@d/sshd@g' /etc/pam.d/login > /etc/pam.d/sshd
	chmod 644 /etc/pam.d/sshd
	echo "UsePAM yes" >> /etc/ssh/sshd_config
fi
cat << EOF >> /etc/ssh/sshd_config

#AllowAgentForwarding yes
#AllowTcpForwarding yes
#GatewayPorts no
X11Forwarding yes
#X11DisplayOffset 10
#X11UseLocalhost yes
#PermitTTY yes
PrintMotd no
#PrintLastLog yes
#TCPKeepAlive yes
#PermitUserEnvironment no
#Compression delayed
#ClientAliveInterval 0
#ClientAliveCountMax 3
#UseDNS no
#PidFile /run/sshd.pid
#MaxStartups 10:30:100
#PermitTunnel no
#ChrootDirectory none
#VersionAddendum none

# no default banner path
#Banner none

# Allow client to pass locale environment variables
AcceptEnv LANG LC_*

# override default of no subsystems
Subsystem       sftp    /usr/lib/openssh/sftp-server

# Example of overriding settings on a per-user basis
#Match User anoncvs
#       X11Forwarding no
#       AllowTcpForwarding no
#       PermitTTY no
#       ForceCommand cvs server
EOF
fi

#ssh-keygen
#ssh-copy-id -i ~/.ssh/id_ed25519.pub REMOTE_USERNAME@REMOTE_HOSTNAME

pushd /etc/extension/startupfiles
make install-sshd
popd

update_version_list $PKG_OPENSSH
