DESCRIPTION="The OpenSP package contains a C++ library for using SGML/XML files."

#EXT_VERSION=$(basename $PKG_OPENSP .tar.gz | cut -d "-" -f 2) 
EXT_VERSION="1.5.2"

[ -f ../$(basename $PATCH_OPENSP) ] && patch -Np1 -i ../$(basename $PATCH_OPENSP)
sed -i 's/32,/253,/' lib/Syntax.cxx
sed -i 's/LITLEN          240 /LITLEN          8092/' \
    unicode/{gensyntax.pl,unicode.syn}

./configure --prefix=/usr                              \
            --disable-static                           \
            --disable-doc-build                        \
            --enable-default-catalog=/etc/sgml/catalog \
            --enable-http                              \
            --enable-default-search-path=/usr/share/sgml

make pkgdatadir=/usr/share/sgml/OpenSP-${EXT_VERSION}

# As root:
make pkgdatadir=/usr/share/sgml/OpenSP-${EXT_VERSION} \
     docdir=/usr/share/doc/OpenSP-${EXT_VERSION}      \
     install

[ ! -h /usr/bin/nsgmls ] && ln -v -sf onsgmls   /usr/bin/nsgmls
[ ! -h /usr/bin/sgmlnorm ] && ln -v -sf osgmlnorm /usr/bin/sgmlnorm
[ ! -h /usr/bin/spam ] && ln -v -sf ospam     /usr/bin/spam
[ ! -h /usr/bin/spcat ] && ln -v -sf ospcat    /usr/bin/spcat
[ ! -h /usr/bin/spent ] && ln -v -sf ospent    /usr/bin/spent 
[ ! -h /usr/bin/sx ] && ln -v -sf osx       /usr/bin/sx
[ ! -h /usr/bin/sgml2xml ] && ln -v -sf osx       /usr/bin/sgml2xml
[ ! -h /usr/lib/libsp.so ] && ln -v -sf libosp.so /usr/lib/libsp.so

update_version_list opensp-$EXT_VERSION
