DESCRIPTION="OpenJPEG is an open-source implementation of the JPEG-2000 standard."
# OpenJPEG
# OpenJPEG is an open-source implementation of the JPEG-2000 standard. OpenJPEG fully respects the JPEG-2000 specifications and can compress/decompress lossless 16-bit images. 

# Contents
# Installed Programs: opj_compress, opj_decompress, and opj_dump
# Installed Libraries: libopenjp2.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/openjpeg-2.5 and /usr/lib/openjpeg-2.5

# Short Descriptions
# opj_compress - converts various image formats to the jpeg2000 format
# opj_decompress - converts jpeg2000 images to other image types
# opj_dump - reads in a jpeg2000 image and dumps the contents to stdout

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_OPENJPEG .tar.gz | cut -d "-" -f 2) 

mkdir -v build &&
cd       build &&

cmake -D CMAKE_BUILD_TYPE=Release  \
      -D CMAKE_INSTALL_PREFIX=/usr \
      -D BUILD_STATIC_LIBS=OFF ..  &&
make

# git clone https://github.com/uclouvain/openjpeg-data.git --depth 1 &&
# OPJ_DATA_ROOT=$PWD/openjpeg-data cmake -D BUILD_TESTING=ON ..      &&
# make                                                               &&
# make test

# As root:
make install
cp -rv ../doc/man -T /usr/share/man

update_version_list $PKG_OPENJPEG
