DESCRIPTION="OpenJDK is an open-source implementation of Oracle's Java Standard Edition platform. OpenJDK is useful for developing Java programs, and provides a complete runtime environment to run Java programs."

EXT_VERSION=$(basename $PKG_OPENJDK .tar.gz | cut -d "-" -f 2) 

source /etc/profile

[ -f ../$(basename $TEST_OPENJDK) ] && tar -xf ../$(basename $TEST_OPENJDK)

[[ $(command -v cxpm) == "" ]] && OPTIONS="--without-x" || OPTIONS=""
[[ $(command -v giftool) != "" ]] && OPTIONS="$OPTIONS --with-giflib=system"
[[ $(command -v hb-info) != "" ]] && OPTIONS="$OPTIONS --with-harfbuzz=system"
[[ $(command -v jpgicc) != "" ]] && OPTIONS="$OPTIONS --with-lcms=system"
[[ $(command -v cjpeg) != "" ]] && OPTIONS="$OPTIONS --with-libjpeg=system"
[[ $(command -v pngfix) != "" ]] && OPTIONS="$OPTIONS --with-libpng=system"
echo $OPTIONS

unset JAVA_HOME
unset CLASSPATH
unset MAKEFLAGS
bash configure --enable-unlimited-crypto    \
               --disable-warnings-as-errors \
               --with-stdc++lib=dynamic     \
               --with-jtreg=$PWD/jtreg      \
               --with-zlib=system           \
               --with-version-build="7"     \
               --with-version-pre=""        \
               --with-version-opt=""        \
               --with-jobs=$(nproc)         \
               --with-cacerts-file=/etc/pki/tls/java/cacerts \
			   $OPTIONS
make images

# As root:
install -vdm755 /opt/jdk-23.0.2+7             &&
cp -Rv build/*/images/jdk/* /opt/jdk-23.0.2+7 &&
chown -R root:root /opt/jdk-23.0.2+7          &&
for s in 16 24 32 48; do
  install -vDm644 src/java.desktop/unix/classes/sun/awt/X11/java-icon${s}.png \
                  /usr/share/icons/hicolor/${s}x${s}/apps/java.png
done

[ -h /opt/jdk ] && unlink /opt/jdk
ln -v -nsf jdk-23.0.2+7 /opt/jdk

[ -d /opt/OpenJDK-23.0.2-bin ] && rm -r  /opt/OpenJDK-23.0.2-bin

mkdir -pv /usr/share/applications &&

cat > /usr/share/applications/openjdk-java.desktop << "EOF" &&
[Desktop Entry]
Name=OpenJDK Java 23.0.2 Runtime
Comment=OpenJDK Java 23.0.2 Runtime
Exec=/opt/jdk/bin/java -jar
Terminal=false
Type=Application
Icon=java
MimeType=application/x-java-archive;application/java-archive;application/x-jar;
NoDisplay=true
EOF
cat > /usr/share/applications/openjdk-jconsole.desktop << "EOF"
[Desktop Entry]
Name=OpenJDK Java 23.0.2 Console
Comment=OpenJDK Java 23.0.2 Console
Keywords=java;console;monitoring
Exec=/opt/jdk/bin/jconsole
Terminal=false
Type=Application
Icon=java
Categories=Application;System;
EOF

[ ! -h /opt/jdk/lib/security/cacerts ] && ln -sfv /etc/pki/tls/java/cacerts /opt/jdk/lib/security/cacerts

cd /opt/jdk
echo '' | bin/keytool -list -cacerts

update_version_list $PKG_OPENJDK
