DESCRIPTION="The OpenJade package contains a DSSSL engine."

EXT_VERSION=$(basename $PKG_OPENJADE .tar.gz | cut -d "-" -f 2) 

[ -f ../$(basename $PATCH_OPENJADE) ] && patch -Np1 -i ../$(basename $PATCH_OPENJADE)

sed -i -e '/getopts/{N;s#&G#g#;s#do .getopts.pl.;##;}' \
       -e '/use POSIX/ause Getopt::Std;' msggen.pl

export CXXFLAGS="${CXXFLAGS:--O2 -g} -fno-lifetime-dse" 
./configure --prefix=/usr                                \
            --mandir=/usr/share/man                      \
            --enable-http                                \
            --disable-static                             \
            --enable-default-catalog=/etc/sgml/catalog   \
            --enable-default-search-path=/usr/share/sgml \
            --datadir=/usr/share/sgml/openjade-${EXT_VERSION}
make

# As root:
make install 
make install-man  
[ ! -h /usr/bin/jade ] && ln -v -sf openjade /usr/bin/jade 
[ ! -h /usr/lib/libgrove.so ] && ln -v -sf libogrove.so /usr/lib/libgrove.so 
[ ! -h /usr/lib/libspgrove.so ] && ln -v -sf libospgrove.so /usr/lib/libspgrove.so  
[ ! -h /usr/lib/libstyle.so ] && ln -v -sf libostyle.so /usr/lib/libstyle.so 

install -v -m644 dsssl/catalog /usr/share/sgml/openjade-${EXT_VERSION}/

install -v -m644 dsssl/*.{dtd,dsl,sgm}              \
    /usr/share/sgml/openjade-${EXT_VERSION}

install-catalog --add /etc/sgml/openjade-${EXT_VERSION}.cat  \
    /usr/share/sgml/openjade-${EXT_VERSION}/catalog 

install-catalog --add /etc/sgml/sgml-docbook.cat    \
    /etc/sgml/openjade-${EXT_VERSION}.cat

update_version_list $PKG_OPENJADE
