DESCRIPTION="The opencv package contains graphics libraries mainly aimed at real-time computer vision."

[[ $(cmake --version | sed 2,5d | cut -d " " -f 3 | cut -d "." -f 1) == 4 ]] && OPTIONS="-D CMAKE_POLICY_VERSION_MINIMUM=3.5" || OPTIONS=""

EXT_VERSION=$(basename $PKG_OPENCV .tar.gz | cut -d "-" -f 2) 

tar -xf ../$(basename $PKG_OPENCV_CONTRIB)

mkdir build &&
cd    build &&

cmake -D CMAKE_INSTALL_PREFIX=/usr      \
      -D CMAKE_BUILD_TYPE=Release       \
      -D ENABLE_CXX11=ON                \
      -D BUILD_PERF_TESTS=OFF           \
      -D WITH_XINE=ON                   \
      -D BUILD_TESTS=OFF                \
      -D ENABLE_PRECOMPILED_HEADERS=OFF \
      -D CMAKE_SKIP_INSTALL_RPATH=ON    \
      -D BUILD_WITH_DEBUG_INFO=OFF      \
      -D OPENCV_GENERATE_PKGCONFIG=ON   \
      -W no-dev  $OPTIONS ..  
make

# As root:
make install

update_version_list $PKG_OPENCV
