DESCRIPTION="NumPy is the fundamental package for scientific computing with Python."
# NumPy Python Module
# NumPy is the fundamental package for scientific computing with Python.

# Contents
# Installed Programs: f2py, f2py3 and f2py3.13 (3 copies of the same script)
# Installed Libraries: None
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/lib/python3.13/site-packages/numpy

# Short Descriptions
# f2py - is the Fortran to Python interface generator utility.

# Required
# cython-3.0.12, meson_python-0.17.1, and pyproject-metadata-0.9.0

# Recommended
# None

# Optional
# fortran from GCC-14.2.0, lapack and cblas, and openblas

# Optional_Testing
# attrs-25.1.0, pytest-8.3.5, pytz-2025.1, and hypothesis

EXT_VERSION=$(basename $PKG_NUMPY .tar.?z*)

pip3 wheel -w dist --no-build-isolation --no-deps --no-cache-dir $PWD

# As root:
pip3 install --no-index --find-links dist --no-user numpy

mkdir -p test                                  &&
cd       test                                  &&
python3 -m venv --system-site-packages testenv &&
source testenv/bin/activate                    &&
pip3 install hypothesis                        &&
python3 -c "import numpy, sys; sys.exit(numpy.test() is False)"
deactivate

# -w dist: builds the appropriate "wheel" for this module in the directory dist.
# --no-build-isolation: tells pip3 to run the build in the system environment instead of creating a temporary build environment.
# --no-deps: prevents pip3 from building wheels for the project's dependencies.
# --no-index: ignores the package index (only looking at --find-links URLs instead).
# --find-links dist: looks for links to archives such as wheel (.whl) files in the directory dist.
# --no-cache-dir: disables the cache to prevent a warning when installing as the root user.
# --no-user: Prevent mistakenly running the install command as a non-root user.
# --upgrade: Upgrade the package to the newest available version. This option is used with the install command if a version of the package is already installed.
# --force-reinstall: Reinstall the package even if it is up-to-date. This option is used with the install command if reinstalling the package or reverting to an earlier version of the package.
# --no-deps: Do not install package dependencies. This option may be needed with the --upgrade or --force-reinstall options.

update_version_list $PKG_NUMPY
