DESCRIPTION="The ntp package contains a client and server to keep the time synchronized between various computers over a network."

EXT_VERSION=$(basename $PKG_NTP .tar.gz | cut -d "-" -f 2) 

[[ $(cat /etc/group | grep ntp) == "" ]] && groupadd -g 87 ntp

[[ $(cat /etc/passwd | grep ntp:) == "" ]] && useradd -c "Network Time Protocol" -d /var/lib/ntp -u 87 -g ntp -s /bin/false ntp

sed -e "s;pthread_detach(NULL);pthread_detach(0);" -i configure sntp/configure

./configure --prefix=/usr         \
            --bindir=/usr/sbin    \
            --sysconfdir=/etc     \
            --enable-linuxcaps    \
            --with-lineeditlibs=readline \
            --docdir=/usr/share/doc/ntp-$EXT_VERSION
make

# As root:
make install
install -v -o ntp -g ntp -d /var/lib/ntp

update_version_list $PKG_NTP
