DESCRIPTION="The Ntfs-3g package contains a stable, read-write open source driver for NTFS partitions."

EXT_VERSION=$(basename $PKG_NTFS_3G .tgz | cut -d "-" -f 3) 

PASS=false
[[ $(cat /boot/config-$(uname -r) | grep CONFIG_NTFS3_FS=y) == "CONFIG_NTFS3_FS=y" ]] && PASS=true
[[ $(cat /boot/config-$(uname -r) | grep CONFIG_NTFS3_FS=m) == "CONFIG_NTFS3_FS=m" ]] && PASS=true
[[ $PASS == "false" ]] && echo kernel test failed && exit -1

PASS=false
[[ $(cat /boot/config-$(uname -r) | grep CONFIG_FUSE_FS=y) == "CONFIG_FUSE_FS=y" ]] && PASS=true
[[ $(cat /boot/config-$(uname -r) | grep CONFIG_FUSE_FS=m) == "CONFIG_FUSE_FS=m" ]] && PASS=true
[[ $PASS == "false" ]] && echo kernel test failed && exit -1


./configure --prefix=/usr        \
            --disable-static     \
            --with-fuse=internal \
            --docdir=/usr/share/doc/ntfs-3g-$EXT_VERSION
make

# As root:
make install

cat > /usr/sbin/mount.ntfs << "EOF" &&
#!/bin/sh
exec mount -t ntfs3 "$@"
EOF
chmod -v 755 /usr/sbin/mount.ntfs

update_version_list $PKG_NTFS_3G
