DESCRIPTION="The Network Security Services (NSS) package is a set of libraries designed to support cross-platform development of security-enabled client and server applications."
# NSS
# The Network Security Services (NSS) package is a set of libraries designed to support cross-platform development of security-enabled client and server applications. Applications built with NSS can support SSL v2 and v3, TLS, PKCS #5, PKCS #7, PKCS #11, PKCS #12, S/MIME, X.509 v3 certificates, and other security standards. This is useful for implementing SSL and S/MIME or other Internet security standards into an application.

# Contents
# Installed Programs: certutil, nss-config, and pk12util
# Installed Libraries: libcrmf.a, libfreebl3.so, libfreeblpriv3.so, libnss3.so, libnssckbi.so, libnssckbi-testlib.so, libnssdbm3.so, libnsssysinit.so, libnssutil3.so, libpkcs11testmodule.so, libsmime3.so, libsoftokn3.so, and libssl3.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/nss

# Short Descriptions
# certutil - is the Mozilla Certificate Database Tool. It is a command-line utility that can create and modify the Netscape Communicator cert8.db and key3.db database files. It can also list, generate, modify, or delete certificates within the cert8.db file and create or change the password, generate new public and private key pairs, display the contents of the key database, or delete key pairs within the key3.db file
# nss-config - is used to determine the NSS library settings of the installed NSS libraries
# pk12util - is a tool for importing certificates and keys from pkcs #12 files into NSS or exporting them. It can also list certificates and keys in such files

# Required
# NSPR-4.36

# Recommended
# SQLite-3.49.1 and p11-kit-0.25.5 (runtime)

# Optional
# None

# Optional_Documentation
# None

# Optional_Testing
# None

#EXT_VERSION=$(basename $PKG_NSS .tar.gz | cut -d "-" -f 2)

[[ -f ../$(basename $PATCH_NSS) ]] && patch -Np1 -i ../$(basename $PATCH_NSS)

cd nss

make BUILD_OPT=1                      \
  NSPR_INCLUDE_DIR=/usr/include/nspr  \
  USE_SYSTEM_ZLIB=1                   \
  ZLIB_LIBS=-lz                       \
  NSS_ENABLE_WERROR=0                 \
  $([ $(uname -m) = x86_64 ] && echo USE_64=1) \
  $([ -f /usr/include/sqlite3.h ] && echo NSS_USE_SYSTEM_SQLITE=1)

#cd tests &&
#HOST=localhost DOMSUF=localdomain ./all.sh
#cd ../

# As root:
cd ../dist

install -v -m755 Linux*/lib/*.so              /usr/lib
install -v -m644 Linux*/lib/{*.chk,libcrmf.a} /usr/lib

install -v -m755 -d                           /usr/include/nss
cp -v -RL {public,private}/nss/*              /usr/include/nss

install -v -m755 Linux*/bin/{certutil,nss-config,pk12util} /usr/bin

install -v -m644 Linux*/lib/pkgconfig/nss.pc  /usr/lib/pkgconfig

#[ -f /lib/libp11-kit.so ] && ln -sfv ./pkcs11/p11-kit-trust.so /usr/lib/libnssckbi.so

[ -h /usr/lib/libnssckbi.so ] && unlink /usr/lib/libnssckbi.so

[ -f /usr/lib/libnssckbi.so ] && ln -sfv ./pkcs11/p11-kit-trust.so /usr/lib/libnssckbi.so

if $MULTILIB
then
	cd ../nss
	find -name "Linux*.OBJ" -type d -exec rm -rf {} +
	rm -rf ../dist
	
	CC="gcc -m32" CXX="g++ -m32"         	\
	make BUILD_OPT=1                      	\
		NSPR_INCLUDE_DIR=/usr/include/nspr  \
		USE_SYSTEM_ZLIB=1                   \
		ZLIB_LIBS=-lz                       \
		NSS_ENABLE_WERROR=0                 \
		$([ $(uname -m) = x86_64 ] && echo USE_64=1) \
		$([ -f /usr/include/sqlite3.h ] && echo NSS_USE_SYSTEM_SQLITE=1)
	
	cd ../dist
	
	install -v -m755 Linux*/lib/*.so              /usr/lib32           &&
	install -v -m644 Linux*/lib/{*.chk,libcrmf.a} /usr/lib32           &&
	sed -i 's/lib/lib32/g' Linux*/lib/pkgconfig/nss.pc                 &&
	install -v -m644 Linux*/lib/pkgconfig/nss.pc  /usr/lib32/pkgconfig &&
	ldconfig
fi
if $MULTILIB_X32	
then
	cd ../nss
	find -name "Linux*.OBJ" -type d -exec rm -rf {} +
	rm -rf ../dist

	CC="gcc -mx32" CXX="g++ -mx32"         		\
	make BUILD_OPT=1                      	\
		NSPR_INCLUDE_DIR=/usr/include/nspr  \
		USE_SYSTEM_ZLIB=1                   \
		ZLIB_LIBS=-lz                       \
		NSS_ENABLE_WERROR=0                 \
		$([ $(uname -m) = x86_64 ] && echo USE_64=1) \
		$([ -f /usr/include/sqlite3.h ] && echo NSS_USE_SYSTEM_SQLITE=1)
	
	cd ../dist
	
	install -v -m755 Linux*/lib/*.so              /usr/libx32           &&
	install -v -m644 Linux*/lib/{*.chk,libcrmf.a} /usr/libx32           &&
	sed -i 's/lib/libx32/g' Linux*/lib/pkgconfig/nss.pc                 &&
	install -v -m644 Linux*/lib/pkgconfig/nss.pc  /usr/libx32/pkgconfig &&
	ldconfig	
fi

update_version_list $PKG_NSS
