DESCRIPTION="Netscape Portable Runtime (NSPR) provides a platform-neutral API for system level and libc like functions."
# NSPR
# Netscape Portable Runtime (NSPR) provides a platform-neutral API for system level and libc like functions.

# Contents
# Installed Programs: nspr-config
# Installed Libraries: ibnspr4.so, libplc4.so, and libplds4.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/nspr

# Short Descriptions
# nspr-config - provides compiler and linker options to other packages that use NSPR
# libnspr4.so - contains functions that provide platform independence for non-GUI operating system facilities such as threads, thread synchronization, normal file and network I/O, interval timing and calendar time, basic memory management and shared library linking
# libplc4.so - contains functions that implement many of the features offered by libnspr4
# libplds4.so - contains functions that provide data structures

# Required
# None

# Recommended
# None

# Optional
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_NSPR .tar.?z*)

cd nspr &&

sed -i '/^RELEASE/s|^|#|' pr/src/misc/Makefile.in &&
sed -i 's|$(LIBRARY) ||'  config/rules.mk         &&

./configure --prefix=/usr   \
            --with-mozilla  \
            --with-pthreads \
            $([ $(uname -m) = x86_64 ] && echo --enable-64bit) &&
make

# As root:
make install

if $MULTILIB
then
	make distclean 
	# export CFLAGS="-m32"
	# export LDFLAGS="-m32"
	CC="gcc -m32" CXX="g++ -m32"         	\
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig	\
	./configure --prefix=/usr 				\
				--libdir=/usr/lib32			\
				--host=i686-pc-linux-gnu	\
				--with-mozilla         		\
				--with-pthreads          	\
				--disable-64bit
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	make distclean
	# export CFLAGS="-mx32"
	# export LDFLAGS="-mx32"
	CC="gcc -mx32" CXX="g++ -mx32"         		\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig		\
	./configure --prefix=/usr 					\
				--libdir=/usr/libx32			\
				--host=x86_64-pc-linux-gnux32	\
				--with-mozilla         			\
				--with-pthreads          		\
				--disable-64bit
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 
	ldconfig	
fi

update_version_list $PKG_NSPR
