DESCRIPTION="NetworkManager is a set of co-operative tools that make networking simple and straightforward."
# blank
# The 

# Contents
# Installed Programs: None
# Installed Libraries: None
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: None

# Short Descriptions
# None

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_NETWORKMANAGER .tar.gz | cut -d "-" -f 2) 

grep -rl '^#!.*python$' | xargs sed -i '1s/python/&3/'

mkdir build
cd    build

meson setup ..                    \
      --prefix=/usr               \
      --buildtype=release         \
      -D libaudit=no              \
      -D nmtui=true               \
      -D ovs=true                \
      -D ppp=false                \
      -D selinux=false            \
      -D valgrind=true            \
      -D qt=false                 \
      -D session_tracking=systemd \
      -D modem_manager=true      \
	  -D crypto=gnutls			\
	  -D docs=false

ninja

# As root:
ninja install
mv -v /usr/share/doc/NetworkManager{,-${EXT_VERSION}}

if [[ $(command -v gtkdocize) != "" ]]; then
	for file in $(echo ../man/*.[1578]); do
		section=${file##*.} &&
		install -vdm 755 /usr/share/man/man$section
		install -vm 644 $file /usr/share/man/man$section/
	done

	cp -Rv ../docs/{api,libnm} /usr/share/doc/NetworkManager-${EXT_VERSION}
fi

update_version_list $PKG_NETWORKMANAGER
