DESCRIPTION="NetworkManager is a set of co-operative tools that make networking simple and straightforward."

EXT_VERSION=$(basename $PKG_NETWORKMANAGER .tar.xz | cut -d "-" -f 2) 

grep -rl '^#!.*python$' | xargs sed -i '1s/python/&3/'

mkdir build
cd    build

meson setup ..                    \
      --prefix=/usr               \
      --buildtype=release         \
      -D libaudit=no              \
      -D nmtui=true               \
      -D ovs=true                \
      -D ppp=false                \
      -D selinux=false            \
      -D valgrind=true            \
      -D qt=false                 \
      -D session_tracking=systemd \
      -D modem_manager=true      \
	  -D crypto=gnutls			\
	  -D docs=false

ninja

# As root:
ninja install
mv -v /usr/share/doc/NetworkManager{,-${EXT_VERSION}}

if [[ $(command -v gtkdocize) != "" ]]; then
	for file in $(echo ../man/*.[1578]); do
		section=${file##*.} &&
		install -vdm 755 /usr/share/man/man$section
		install -vm 644 $file /usr/share/man/man$section/
	done

	cp -Rv ../docs/{api,libnm} /usr/share/doc/NetworkManager-${EXT_VERSION}
fi

update_version_list $PKG_NETWORKMANAGER
