DESCRIPTION="The NetworkManager Applet provides a tool and a panel applet used to configure wired and wireless network connections through GUI."

EXT_VERSION=$(basename $PKG_NETWORK_MANAGER_APPLET .tar.gz | cut -d "-" -f 2) 

mkdir build &&
cd    build &&

meson setup ..            \
      --prefix=/usr       \
      --buildtype=release \
      -D appindicator=no  \
      -D selinux=false    \
      -D team=false       &&
ninja

# -D appindicator=no: This switch disables AppIndicator support in network-manager-applet because it requires libindicator, which is not in BLFS. The build will fail without this option.
# -D selinux=false: This switch forcibly disables SELinux support since it is not currently in BLFS and the build will fail without it.
# -D team=false: This switch disables the team configuration editor since it requires jansson-2.14. If you have Jansson installed, remove this option or set it to true.
# -D wwan=false: This switch disables WWAN support. Use this if you do not have ModemManager-1.18.12 installed.

# As root:
ninja install

update_version_list $PKG_NETWORK_MANAGER_APPLET
