DESCRIPTION="The mpg123 package contains a console-based MP3 player."
# mpg123
# The mpg123 package contains a console-based MP3 player. It claims to be the fastest MP3 decoder for Unix. 

# Contents
# Installed Programs: mpg123, mpg123-id3dump, mpg123-strip, and out123
# Installed Libraries: libmpg123.so, libout123.so, and libsyn123.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/lib/mpg123

# Short Descriptions
# mpg123 - is used for playing MP3 files via the console
# mpg123-id3dump - is a tool to dump ID3 meta data from MPEG audio files using libmpg123
# mpg123-strip - extracts only MPEG frames from a stream using libmpg123 (stdin to stdout)
# out123 - plays raw PCM audio to an output device
# libmpg123.so - contains the mpg123 API functions
# libout123.so - contains the out123 API functions
# libsyn123.so - contains some audio signal synthesis and format conversion functions

# Required
# None

# Recommended
# alsa-lib-1.2.13

# Recommended_Runtime
# None

# Optional
# PulseAudio-17.0, SDL2-2.30.11, JACK, OpenAL and PortAudio

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_MPG123 .tar.bz2 | cut -d "-" -f 2) 

./configure --prefix=/usr &&
make

# As root:
make install

update_version_list $PKG_MPG123
