DESCRIPTION="ModemManager provides a unified high level API for communicating with mobile broadband modems, regardless of the protocol used to communicate with the actual device."

EXT_VERSION=$(basename $PKG_MODEMMANAGER .tar.gz | cut -d "-" -f 2) 

mkdir build &&
cd    build &&

meson setup ..                 \
      --prefix=/usr            \
      --buildtype=release      \
      -D bash_completion=false \
      -D man=false             \
      -D qrtr=false
ninja

# --buildtype=release: Specify a buildtype suitable for stable releases of the package, as the default may produce unoptimized binaries.
# -D bash_completion=false: Use this option if the external bash-completion package is not installed.
# -D man=false: Use this option if the external help2man package is not installed.
# -D qrtr=false: This switch disables support for the QRTR protocol which needs the external libqrtr-glib package.

# As root:
ninja install

systemctl enable ModemManager

update_version_list modemmanager-$EXT_VERSION
