DESCRIPTION="MIT Kerberos V5 is a free implementation of Kerberos 5."

EXT_VERSION=$(basename $PKG_MIT_KERBEROS_V5 .tar.gz | cut -d "-" -f 2) 

cd src
sed -i -e '/eq 0/{N;s/12 //}' plugins/kdb/db2/libdb2/test/run.test

GCC15=""
GXX15=""
[ $(gcc -dumpversion | cut -d "." -f 1) == 15 ] && GCC15="-std=gnu17" && GXX15="-std=gnu++17"

CC="gcc $GCC15" CXX="g++ $GXX15"     \
./configure --prefix=/usr            \
            --sysconfdir=/etc        \
            --localstatedir=/var/lib \
            --runstatedir=/run       \
            --with-system-et         \
            --with-system-ss         \
            --with-system-verto=no   \
            --enable-dns-for-realm   \
            --disable-rpath 		 \
			--with-ldap
make

# As root:
make install
cp -vfr ../doc -T /usr/share/doc/krb5-$EXT_VERSION

update_version_list mit_kerberos_v5-$EXT_VERSION
