DESCRIPTION="Meson build system support for cross compilation"

EXT_VERSION=12.3

mkdir -pv /usr/share/meson/cross &&

cat > /usr/share/meson/cross/lib32 << "EOF"
[binaries]
c = ['gcc', '-m32']
cpp = ['g++', '-m32']
rust = ['rustc', '--target', 'i686-unknown-linux-gnu']
pkg-config = 'i686-pc-linux-gnu-pkg-config'
ar = '/usr/bin/ar'
strip = '/usr/bin/strip'
cups-config = 'cups-config'
llvm-config = 'llvm-config'
exe_wrapper = ''

[properties]
sizeof_void* = 4
sizeof_long = 4

[host_machine]
system = 'linux'
subsystem = 'linux'
kernel = 'linux'
cpu_family = 'x86'
cpu = 'i686'
endian = 'little'
EOF

# guessed:
cat > /usr/share/meson/cross/libx32 << "EOF"
[binaries]
c = ['gcc', '-mx32']
cpp = ['g++', '-mx32']
rust = ['rustc', '--target', 'x86_64-pc-linux-gnux32']
pkg-config = 'x86_64-pc-linux-gnux32-pkg-config'
ar = '/usr/bin/ar'
strip = '/usr/bin/strip'
cups-config = 'cups-config'
llvm-config = 'llvm-config'
exe_wrapper = ''

[properties]
sizeof_void* = 4
sizeof_long = 4

[host_machine]
system = 'linux'
subsystem = 'linux'
kernel = 'linux'
cpu_family = 'x86'
cpu = 'x86_64'
endian = 'little'
EOF

mkdir -pv /usr/share/meson/native &&

cat > /usr/share/meson/native/x86 << "EOF"
[binaries]
c = ['gcc', '-m32']
cpp = ['g++', '-m32']
rust = ['rustc', '--target', 'i686-unknown-linux-gnu']
pkg-config = 'i686-pc-linux-gnu-pkg-config'
ar = '/usr/bin/ar'
strip = '/usr/bin/strip'
cups-config = 'cups-config'
llvm-config = 'llvm-config'
exe_wrapper = ''

[properties]
sizeof_void* = 4
sizeof_long = 4

[host_machine]
system = 'linux'
subsystem = 'linux'
kernel = 'linux'
cpu_family = 'x86'
cpu = 'i686'
endian = 'little'
EOF

# meson setup .. --cross-file=lib32 <other-options>
# meson setup .. --cross-file=libx32 <other-options>
# meson setup .. --native-file=x86 <other-options>

update_version_list meson_toolchain_files-$EXT_VERSION
