DESCRIPTION="Mesa is an OpenGL compatible 3D graphics library."

source /etc/profile

# Test for kernel options
PASS=true
[[ $(cat /boot/config-$(uname -r) | grep CONFIG_DRM=y) == "CONFIG_DRM=y" ]] && echo found || echo CONFIG_DRM not found && PASS=false
[[ $(cat /boot/config-$(uname -r) | grep CONFIG_DRM_AMDGPU=y) == "CONFIG_DRM_AMDGPU=y" ]] && echo found || echo CONFIG_DRM_AMDGPU not found && PASS=false
[[ $(cat /boot/config-$(uname -r) | grep CONFIG_DRM_AMDGPU_SI=y) == "CONFIG_DRM_AMDGPU_SI=y" ]] && echo found || echo CONFIG_DRM_AMDGPU_SI not found && PASS=false
[[ $(cat /boot/config-$(uname -r) | grep CONFIG_DRM_AMDGPU_CIK=y) == "CONFIG_DRM_AMDGPU_CIK=y" ]] && echo found || echo CONFIG_DRM_AMDGPU_CIK not found && PASS=false
[[ $(cat /boot/config-$(uname -r) | grep CONFIG_DRM_AMD_DC=y) == "CONFIG_DRM_AMD_DC=y" ]] && echo found || echo CONFIG_DRM_AMD_DC not found && PASS=false
[[ $(cat /boot/config-$(uname -r) | grep CONFIG_DRM_NOUVEAU=y) == "CONFIG_DRM_NOUVEAU=y" ]] && echo found || echo CONFIG_DRM_NOUVEAU not found && PASS=false
[[ $(cat /boot/config-$(uname -r) | grep CONFIG_DRM_NOUVEAU_GSP_DEFAULT=y) == "CONFIG_DRM_NOUVEAU_GSP_DEFAULT=y" ]] && echo found || echo CONFIG_DRM_NOUVEAU_GSP_DEFAULTnot found && PASS=false
[[ $(cat /boot/config-$(uname -r) | grep CONFIG_DRM_I915=y) == "CONFIG_DRM_I915=y" ]] && echo found || echo CONFIG_DRM_I915 not found && PASS=false
[[ $(cat /boot/config-$(uname -r) | grep CONFIG_DRM_VGEM=y) == "CONFIG_DRM_VGEM=y" ]] && echo found || echo CONFIG_DRM_VGEM not found && PASS=false
[[ $(cat /boot/config-$(uname -r) | grep CONFIG_DRM_VMWGFX=y) == "CONFIG_DRM_VMWGFX=y" ]] && echo found || echo CONFIG_DRM_VMWGFX not found && PASS=false
[[ $PASS == "false" ]] && echo kernel test failed && echo exit -1

EXT_VERSION=$(basename $PKG_MESA .tar.xz | cut -d "-" -f 2)

mkdir -pv /opt/qt-$EXT_VERSION

if [[ -f ../$(basename $PATCH_MESA) ]]; then
	patch -Np1 -i ../$(basename $PATCH_MESA)
fi

export QT6PREFIX=/opt/qt6

if [ "$(uname -m)" == "i686" ]; then
    sed -e "/^#elif defined(Q_CC_GNU_ONLY)/s/.*/& \&\& 0/" \
        -i qtbase/src/corelib/global/qtypes.h
fi

mkdir build
cd    build

# meson setup ..                 \
      # --prefix=$XORG_PREFIX    \
      # --buildtype=release      \
      # -D platforms=x11,wayland \
      # -D gallium-drivers=auto  \
      # -D vulkan-drivers=auto   \
      # -D valgrind=enabled     \
      # -D video-codecs=all      \
	  # -D egl-native-platform=auto	\
      # -D libunwind=enabled		\
	  # -D legacy-x11="dri2"
meson setup                    \
      --prefix=$XORG_PREFIX    \
      --buildtype=release      \
      -D osmesa=true           \
      -D platforms=x11,wayland \
      -D gallium-drivers=auto  \
      -D vulkan-drivers=auto   \
      -D valgrind=disabled     \
      -D video-codecs=all      \
      -D libunwind=disabled    \
      $(pkgconf libglvnd &&    \
      echo -D glvnd=enabled)   \
      ..
ninja

ninja install

cp -rv ../docs -T /usr/share/doc/mesa-$EXT_VERSION

if $MULTILIB
then
	rm -rf *
	meson setup                    \
		  --cross-file lib32       \
		  --prefix=/usr            \
		  --libdir=/usr/lib32      \
		  --buildtype=release      \
		  -D osmesa=true           \
		  -D platforms=x11,wayland \
		  -D gallium-drivers=auto  \
		  -D vulkan-drivers=auto   \
		  -D valgrind=disabled     \
		  -D video-codecs=all      \
		  -D libunwind=disabled    \
		  $(PKG_CONFIG_PATH=/usr/lib32/pkgconfig \
		  pkgconf libglvnd &&      \
		  echo -D glvnd=enabled)   \
		  .. &&
		  sed -i 's/\/usr\/lib\//\/usr\/lib32\//g' ./build.ninja &&

	BINDGEN_EXTRA_CLANG_ARGS="-m32" ninja
	DESTDIR=$PWD/DESTDIR ninja install 
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	if [ -d DESTDIR/usr/share/vulkan ]; then
		cp -vR DESTDIR/usr/share/vulkan /usr/share
	fi  
	rm -rf DESTDIR
	/sbin/ldconfig
fi
if $MULTILIB_X32
then
	rm -rf *
	meson setup                    \
		  --cross-file libx32       \
		  --prefix=/usr            \
		  --libdir=/usr/libx32      \
		  --buildtype=release      \
		  -D osmesa=true           \
		  -D platforms=x11,wayland \
		  -D gallium-drivers=auto  \
		  -D vulkan-drivers=auto   \
		  -D valgrind=disabled     \
		  -D video-codecs=all      \
		  -D libunwind=disabled    \
		  $(PKG_CONFIG_PATH=/usr/libx32/pkgconfig \
		  pkgconf libglvnd &&      \
		  echo -D glvnd=enabled)   \
		  .. &&
		  sed -i 's/\/usr\/lib\//\/usr\/libx32\//g' ./build.ninja &&

	BINDGEN_EXTRA_CLANG_ARGS="-mx32" ninja
	DESTDIR=$PWD/DESTDIR ninja install 
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	if [ -d DESTDIR/usr/share/vulkan ]; then
		cp -vR DESTDIR/usr/share/vulkan /usr/share
	fi  
	rm -rf DESTDIR
	/sbin/ldconfig
fi

update_version_list $PKG_MESA
