echo "# $EXTENSION/build_order.txt" 				 	 > $EXTENSION/build_order.txt
echo "# <scriptname> (without .sh)" 					>> $EXTENSION/build_order.txt
echo "" 												>> $EXTENSION/build_order.txt
	
# Required
[ ! -f /etc/profile.d/xorg.sh ] && echo "Installing xorg_build_env" && extension --install xorg_build_env && echo "Finished xorg_build_env"
source /etc/profile.d/xorg.sh
[[ $(command -v cargo) == "" ]] && echo "Installing rustc" && extension --install rustc && echo "Finished rustc"
[ ! -f /etc/extension/extension_xorg_libraries ] && echo "Installing xorg_libraries" && extension --install xorg_libraries && echo "Finished xorg_libraries"
[ ! -f /lib/libdrm.so ] && echo "Installing libdrm" && extension --install libdrm && echo "Finished libdrm"
[[ $(command -v mako-render) == "" ]] && echo "Installing py_mako" && extension --install py_mako && echo "Finished py_mako"
[ ! -d /usr/lib/python*/site-packages/pyyaml-* ] && echo "Installing py_pyyaml" && extension --install py_pyyaml && echo "Finished py_pyyaml"
[ ! -d /usr/include/clc ] && echo "Installing libclc" && extension --install libclc && echo "Finished libclc"
[[ $(command -v dot) == "" ]] && echo "Installing graphviz" && extension --install graphviz && echo "Finished graphviz"

# Recommended
if [[ $INSTALL_RECOMMENDED != false ]]; then 
	[[ $(command -v glslang) == "" ]] && echo "Installing glslang" && extension --install glslang && echo "Finished glslang"
	[[ $(command -v libva) == "" ]] && echo "Installing libva" && extension --install libva && echo "Finished libva"
	[[ $(command -v libvdpau) == "" ]] && echo "Installing libvdpau" && extension --install libvdpau && echo "Finished libvdpau"
	[[ $(command -v clang) == "" ]] && echo "Installing llvm" && extension --install llvm && echo "Finished llvm"
	[ ! -d /usr/share/wayland-protocols ] && echo "Installing wayland_protocols" && extension --install wayland_protocols && echo "Finished wayland_protocols"
	[ ! -d /usr/include/clc ] && echo "Installing libclc" && extension --install libclc && echo "Finished libclc"
	[ ! -f /lib/libvulkan.so ] && echo "Installing vulkan_loader" && extension --install vulkan_loader && echo "Finished vulkan_loader"
	[[ $(command -v ply) == "" ]] && echo "Installing py_ply" && extension --install py_ply && echo "Finished py_ply"
	[[ $(command -v cbindgen) == "" ]] && echo "Installing c_bindgen" && extension --install c_bindgen && echo "Finished c_bindgen"
	[[ $(command -v make-ca) == "" ]] && echo "Installing make_ca" && extension --install make_ca && echo "Finished make_ca"
	[[ $(command -v bindgen) == "" ]] && echo "Installing rust_bindgen" && extension --install rust_bindgen && echo "Finished rust_bindgen"
fi
# Optional
if [[ $INSTALL_OPTIONAL != false ]]; then 
	[[ $(command -v hmac256) == "" ]] && echo "Installing libgcrypt" && extension --install libgcrypt && echo "Finished libgcrypt"
	[ ! -f /lib/libunwind.so ] && echo "Installing libunwind" && extension --install libunwind && echo "Finished libunwind"
	[[ $(command -v sensors) == "" ]] && echo "Installing lm_sensors" && extension --install lm_sensors && echo "Finished lm_sensors"
	[[ $(command -v nettle-hash) == "" ]] && echo "Installing nettle" && extension --install nettle && echo "Finished nettle"
	[[ $(command -v valgrind) == "" ]] && echo "Installing valgrind" && extension --install valgrind && echo "Finished valgrind"

	[ -f /etc/profile.d/rustc.sh ] && source /etc/profile.d/rustc.sh

	[ ! -f /lib/libdrm_intel.so ] && echo "Installing libdrm" && extension --install libdrm --rebuild && echo "Finished libdrm"
fi

if [ $BUILD_ALL == "false" ] && [[ $(command -v glxinfo) == "" ]]; then
	echo "mesa" 										>> $EXTENSION/build_order.txt
fi
if [ $BUILD_ALL == "true" ]; then
	echo "mesa" 										>> $EXTENSION/build_order.txt
fi
echo "complete _" 										>> $EXTENSION/build_order.txt
