DESCRIPTION="Lua is a powerful light-weight programming language designed for extending applications."
# blank
# The 

# Contents
# Installed Programs: None
# Installed Libraries: None
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: None

# Short Descriptions
# None

# Required
# None

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# None

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_LUA .tar.gz | cut -d "-" -f 2) 
EXT_VERSION_1=$(echo $EXT_VERSION | cut -d "." -f 1) 
EXT_VERSION_2=$(echo $EXT_VERSION | cut -d "." -f 2) 

EXT_VERSION_MAJ="${EXT_VERSION_1}.${EXT_VERSION_2}"

cat > lua.pc << "EOF"
V=5.4
R=5.4.7

prefix=/usr
INSTALL_BIN=${prefix}/bin
INSTALL_INC=${prefix}/include
INSTALL_LIB=${prefix}/lib
INSTALL_MAN=${prefix}/share/man/man1
INSTALL_LMOD=${prefix}/share/lua/${V}
INSTALL_CMOD=${prefix}/lib/lua/${V}
exec_prefix=${prefix}
libdir=${exec_prefix}/lib
includedir=${prefix}/include

Name: Lua
Description: An Extensible Extension Language
Version: ${R}
Requires:
Libs: -L${libdir} -llua -lm -ldl
Cflags: -I${includedir}
EOF

patch -Np1 -i ../$(basename $PATCH_LUA)
make linux

# As root:
make INSTALL_TOP=/usr                \
     INSTALL_DATA="cp -d"            \
     INSTALL_MAN=/usr/share/man/man1 \
     TO_LIB="liblua.so liblua.so.${EXT_VERSION_MAJ} liblua.so.${EXT_VERSION}" \
     install

mkdir -pv                      /usr/share/doc/lua-${EXT_VERSION}
cp -v doc/*.{html,css,gif,png} /usr/share/doc/lua-${EXT_VERSION}

install -v -m644 -D lua.pc /usr/lib/pkgconfig/lua.pc

update_version_list $PKG_LUA
