#libslt

# The libxslt package contains XSLT libraries used for extending libxml2 libraries to support XSLT files.

# Contents
# Installed Programs: xslt-config and xsltproc
# Installed Libraries: libexslt.so, libxslt.so and optionally, libxsltmod.so Python module
# Installed Directories: /usr/include/libexslt, /usr/include/libxslt, /usr/lib/cmake/libxslt, 
#						/usr/lib/libxslt-plugins, /usr/share/gtk-doc/lib{xslt,exslt}, 
#						/usr/share/doc/libxslt-1.1.39, and /usr/share/doc/libxslt-python-1.1.39

# Short Descriptions
# xslt-config - is used to find out the pre-processor, linking and compiling flags necessary to use the 
#               libxslt libraries in 3rd-party programs
# xsltproc - is used to apply XSLT stylesheets to XML documents
# libexslt.so - is used to provide extensions to XSLT functions
# libxslt.so - provides extensions to the libxml2 libraries to parse files that use the XSLT format

# Required
# libxml2-2.12.5

# Recommended (at runtime)
# Although it is not a direct dependency, many applications using libxslt will expect docbook-xml-4.5 
# and docbook-xsl-nons-1.79.2 to be present.
# docbook-xml-4.5 and docbook-xsl-nons-1.79.2

# Optional
# libgcrypt-1.10.3

LIBXSLT_VERSION=$(basename $PKG_LIBXSLT .tar.xz)

./configure --prefix=/usr                          \
            --disable-static                       \
            --docdir=/usr/share/doc/$LIBXSLT_VERSION \
            PYTHON=/usr/bin/python3
# --disable-static: This switch prevents installation of static versions of the libraries.
make

if $RUN_TESTS
then
    set +e
    make check
    set -e
fi

# As root:
make install

update_version_list $PKG_LIBXSLT
