# libxml2

# The libxml2 package contains libraries and utilities used for parsing XML files.

# Contents
# Installed Programs: xml2-config, xmlcatalog, and xmllint
# Installed Libraries: libxml2.so
# Installed Directories: /usr/include/libxml2, /usr/lib/cmake/libxml2, /usr/share/doc/libxml2-2.12.5, and /usr/share/gtk-doc/html/libxml2

# Short Descriptions
# xml2-config - determines the compile and linker flags that should be used to compile and link programs that use libxml2
# xmlcatalog - is used to monitor and manipulate XML and SGML catalogs
# xmllint - parses XML files and outputs reports (based upon options) to detect errors in XML coding
# libxml2.so - provides functions for programs to parse files that use the XML format

if [[ -f ../$(basename $PATCH_LIBXML2) ]]; then
	patch -Np1 -i ../$(basename $PATCH_LIBXML2)
fi

LIBXML2_VERSION=$(basename $PKG_LIBXML2 .tar.xz)

./configure --prefix=/usr           \
            --sysconfdir=/etc       \
            --disable-static        \
            --with-history          \
            --with-icu              \
            PYTHON=/usr/bin/python3 \
            --docdir=/usr/share/doc/$LIBXML2_VERSION
# --disable-static: This switch prevents installation of static versions of the libraries.
# --with-history: This switch enables Readline support when running xmlcatalog or xmllint in shell mode.
# --with-icu: This switch enables support for ICU, which provides additional Unicode support. This is needed for some packages in BLFS, such as for QtWebEngine.
# PYTHON=/usr/bin/python3: Allows building the libxml2 module with Python3 instead of Python2.
			
make

# As root: 
make install

# Finally, prevent some packages from unnecessarily linking to ICU using the following commands as the root user:
rm -vf /usr/lib/libxml2.la
sed '/libs=/s/xml2.*/xml2"/' -i /usr/bin/xml2-config

update_version_list $PKG_LIBXML2
