# SANE

# SANE is short for Scanner Access Now Easy. Scanner access, however, is far from easy, since every vendor has their own protocols. The only known protocol that should bring 
# some unity into this chaos is the TWAIN interface, but this is too imprecise to allow a stable scanning framework. Therefore, SANE comes with its own protocol, and the 
# vendor drivers can't be used.

# SANE is split into back ends and front ends. The back ends are drivers for the supported scanners and cameras. The front ends are user interfaces to access the backends.

# Contents
# Installed Programs: gamma4scanimage, sane-config, saned, sane-find-scanner, scanimage, and umax_pp
# Installed Libraries: libsane.so and numerous scanner backend modules
# Installed Directories: /etc/sane.d, /usr/{include,lib,share}/sane, and /usr/share/doc/sane-1.2.1

# Short Descriptions
# gamma4scanimage - creates a gamma table in the format expected by scanimage
# sane-config - is a tool used to determine the compiler and linker flags that should be used to compile and link SANE
# saned - is the SANE daemon that allows remote clients to access image acquisition devices available on the local host
# sane-find-scanner - is a command-line tool to find SCSI and USB scanners and determine their device files. Its primary purpose is to make sure that scanners can be detected by SANE backends
# scanimage - is a command line interface for scanning from image acquisition devices such as flatbed scanners or cameras. It is also used to list the available backend devices
# umax_pp - is a tool used to read information from UMAX parallel port scanners. It can also be used for performing diagnostics on these scanners
# libsane.so - is the application programming interface that is used to communicate between frontends and backends
# libsane-*.so - modules are backend scanning library plugins used to interface with scanning devices. See http://www.sane-project.org/sane-supported-devices.html for a list of supported backends

# Optional (Back Ends)
# Avahi-0.8, Cups-2.4.7, libjpeg-turbo-3.0.1, libtiff-4.6.0, libusb-1.0.27, v4l-utils-1.26.1, Net-SNMP, libieee1284, libgphoto2, and texlive-20230313 (or install-tl-unx)

# Kernel Configuration, Drivers and Additional Packages
# To access your scanner, you will probably need the related kernel drivers and/or additional support packages. A SCSI scanner will need SCSI drivers, a parallel port scanner needs parallel port 
# support (you should use enhanced EPP modes) and perhaps libieee1284, and a USB scanner will need the libusb-1.0.27 package. For HP devices, you may need hplip. Ensure you have the necessary 
# drivers properly configured to access the devices.

SANE_VERSION=$(basename $PKG_SANE .tar.xz)

# The SANE daemon should run with its own group
[ ! $(getent group scanner) ] && groupadd -g 70 scanner

# configure assumes that the user building SANE-backends is a member of the scanner group
[ ! $(id -Gn root | grep -qw scanner) ] && usermod -G scanner -a root

sg scanner -c "                                 \
PYTHON=python3 ./configure --prefix=/usr        \
                           --sysconfdir=/etc    \
                           --localstatedir=/var \
                           --with-lockdir=/run/lock \
						   --docdir=/usr/share/doc/$SANE_VERSION" \
						   [ -f /lib/libusb-1.0.so ] && echo "--enable-libusb_1_0"
                           
# For a USB scanner, if you are linking to libusb-1.0.27, include the configure switch --enable-libusb_1_0.
# sg scanner -c "...": runs the command between double quotes with principal group scanner. This may be needed if the user has been newly added to group scanner, and has not logged out and in.
# PYTHON=python3: This switch forces the build system to use Python 3 instead of Python 2.
# --sysconfdir=/etc: This switch installs the configuration files in /etc/sane.d instead of /usr/etc/sane.d.

make

if $RUN_TESTS
then
    set +e
    make check
    set -e
fi

make install
install -m 644 -v tools/udev/libsane.rules           \
                  /etc/udev/rules.d/65-scanner.rules
mkdir -p          /run/lock/sane
chgrp -v scanner  /run/lock/sane

update_version_list $PKG_SANE
