# CUPS

# The Nettle package contains a low-level cryptographic library that is designed to fit easily in many contexts.

# Contents
# Installed Programs: nettle-hash, nettle-lfib-stream, nettle-pbkdf2, pkcs1-conv and sexp-conv
# Installed Libraries: libhogweed.so and libnettle.so
# Installed Directories: /usr/include/nettle and /usr/share/doc/nettle-3.9.1

# Short Descriptions
# nettle-hash - calculates a hash value using a specified algorithm
# nettle-lfib-stream - outputs a sequence of pseudorandom (non-cryptographic) bytes, using Knuth's lagged fibonacci generator. The stream is useful for testing, but should not be used to generate cryptographic keys or anything else that needs real randomness
# nettle-pbkdf2 - is a password-based key derivation function that takes a password or a passphrase as input and returns a strengthened password, which is protected against pre-computation attacks by using salting and other expensive computations.
# pkcs1-conv - converts private and public RSA keys from PKCS #1 format to sexp format
# sexp-conv - converts an s-expression to a different encoding

# Optional
# Valgrind-3.22.0 (optional for the tests)

NETTLE_VERSION=$(basename $PKG_NETTLE .tar.xz)

./configure --prefix=/usr --disable-static
# --disable-static: This switch prevents installation of static versions of the libraries.

make

if $RUN_TESTS
then
    set +e
    make check
    set -e
fi

# As root:
make install &&
chmod   -v   755 /usr/lib/lib{hogweed,nettle}.so
install -v -m755 -d /usr/share/doc/$NETTLE_VERSION
install -v -m644 nettle.{html,pdf} /usr/share/doc/$NETTLE_VERSION

update_version_list $PKG_NETTLE
