# GnuTLS

# The GnuTLS package contains libraries and userspace tools which provide a secure layer over a reliable transport layer. Currently the GnuTLS library implements the proposed 
# standards by the IETF's TLS working group. Quoting from the TLS 1.3 protocol specification [https://datatracker.ietf.org/doc/rfc8446/]:

# “ TLS allows client/server applications to communicate over the Internet in a way that is designed to prevent eavesdropping, tampering, and message forgery. ”

# GnuTLS provides support for TLS 1.3, TLS 1.2, TLS 1.1, TLS 1.0, and (optionally) SSL 3.0 protocols. It also supports TLS extensions, including server name and max record size. 
# Additionally, the library supports authentication using the SRP protocol, X.509 certificates, and OpenPGP keys, along with support for the TLS Pre-Shared-Keys (PSK) extension, 
# the Inner Application (TLS/IA) extension, and X.509 and OpenPGP certificate handling.

# Contents
# Installed Programs: certtool, danetool, gnutls-cli, gnutls-cli-debug, gnutls-serv, ocsptool, p11tool, psktool, and srptool
# Installed Libraries: libgnutls.so, libgnutls-dane.so, libgnutlsxx.so, libgnutls-openssl.so (optional), and /usr/lib/guile/3.0/extensions/guile-gnutls-v-2.so
# Installed Directories: /usr/include/gnutls, /usr/lib/guile/3.0/site-ccache/gnutls, /usr/share/guile/site/3.0/gnutls, and /usr/share/doc/gnutls-3.8.3

# Short Descriptions
# certtool - is used to generate X.509 certificates, certificate requests, and private keys
# danetool - is a tool used to generate and check DNS resource records for the DANE protocol
# gnutls-cli - is a simple client program to set up a TLS connection to some other computer
# gnutls-cli-debug - is a simple client program to set up a TLS connection to some other computer and produces very verbose progress results
# gnutls-serv - is a simple server program that listens to incoming TLS connections
# ocsptool - is a program that can parse and print information about OCSP requests/responses, generate requests and verify responses
# p11tool - is a program that allows handling data from PKCS #11 smart cards and security modules
# psktool - is a simple program that generates random keys for use with TLS-PSK
# srptool - is a simple program that emulates the programs in the Stanford SRP (Secure Remote Password) libraries using GnuTLS
# libgnutls.so - contains the core API functions and X.509 certificate API functions

# Required
# Nettle-3.9.1

# Recommended (at runtime)
# make-ca-1.13, libunistring-1.1, libtasn1-4.19.0, and p11-kit-0.25.3

# Optional
# Brotli-1.1.0, Doxygen-1.10.0, GTK-Doc-1.33.2, libidn-1.42 or libidn2-2.3.7, libseccomp-2.5.5, Net-tools-2.10 (used during the test suite), texlive-20230313 or 
# install-tl-unx, Unbound-1.19.1 (to build the DANE library), Valgrind-3.22.0 (used during the test suite), autogen, cmocka and datefudge (used during the test 
# suite if the DANE library is built), and Trousers (Trusted Platform Module support)

PACKAGE_VERSION=$(basename $PKG_GNUTLS .tar.xz)

OPTION=""
[ ! -f /lib/libtasn1.so ] && OPTION="--with-included-libtasn1 $OPTION"
[ ! -f /lib/libunistring.so ] && OPTION="--with-included-unistring $OPTION"
[ ! -f /lib/libp11-kit.so ] && OPTION="--without-p11-kit  $OPTION" || OPTION="--with-default-trust-store-pkcs11='pkcs11:'  $OPTION"

./configure --prefix=/usr \
            --docdir=/usr/share/doc/$PACKAGE_VERSION \
			$OPTION 			
			
make

if $RUN_TESTS
then
    set +e
    make check
    set -e
fi

# As root:
make install

update_version_list $PKG_GNUTLS
