# SystemD Phase 4

# While systemd was installed when building LFS, there are many features provided by the package that were not included in the initial installation because 
# Linux-PAM was not yet installed. The systemd package needs to be rebuilt to provide a working systemd-logind service, which provides many additional 
# features for dependent packages.

# Installed Programs: homectl (optional), systemd-cryptenroll (if cryptsetup-2.7.4 is installed), and userdbctl (optional)

# Short Descriptions
# homectl - is a tool to create, remove, change, or inspect a home directory managed by systemd-homed; note that it's useless for the classic UNIX users and 
#			home directories which we are using in LFS/BLFS book
# systemd-cryptenroll - Is used to enroll or remove a system from full disk encryption, as well as set and query private keys and recovery keys
# userdbctl - inspects users, groups, and group memberships
# pam_systemd.so - is a PAM module used to register user sessions with the systemd login manager, systemd-logind


if [[ "$PATCH_SYSTEMD" ]];then
	patch -Np1 -i ../$(basename $PATCH_SYSTEMD)
fi

sed -i -e 's/GROUP="render"/GROUP="video"/' \
       -e 's/GROUP="sgx", //' rules.d/50-udev-default.rules.in


mkdir -p build
cd       build

meson setup ..                \
      --prefix=/usr           \
      --buildtype=release     \
      -D default-dnssec=no    \
      -D firstboot=false      \
      -D install-tests=false  \
      -D ldconfig=false       \
      -D man=auto             \
      -D sysusers=false       \
      -D rpmmacrosdir=no      \
      -D homed=disabled       \
      -D userdb=false         \
      -D mode=release         \
      -D pam=enabled           \
      -D pamconfdir=/etc/pam.d \
      -D dev-kvm-mode=0660    \
      -D nobody-group=nogroup \
      -D sysupdate=disabled   \
      -D ukify=disabled       \
      -D docdir=/usr/share/doc/$(basename $PKG_SYSTEMD .tar.gz)


ninja

ninja install


grep 'pam_systemd' /etc/pam.d/system-session ||
cat >> /etc/pam.d/system-session << "EOF"
# Begin Systemd addition

session  required    pam_loginuid.so
session  optional    pam_systemd.so

# End Systemd addition
EOF

cat > /etc/pam.d/systemd-user << "EOF"
# Begin /etc/pam.d/systemd-user

account  required    pam_access.so
account  include     system-account

session  required    pam_env.so
session  required    pam_limits.so
session  required    pam_loginuid.so
session  optional    pam_keyinit.so force revoke
session  optional    pam_systemd.so

auth     required    pam_deny.so
password required    pam_deny.so

# End /etc/pam.d/systemd-user
EOF

systemctl daemon-reexec

update_version_list $PKG_SYSTEMD
