# NSS

# The Network Security Services (NSS) package is a set of libraries designed to support cross-platform development of security-enabled client and server 
# applications. Applications built with NSS can support SSL v2 and v3, TLS, PKCS #5, PKCS #7, PKCS #11, PKCS #12, S/MIME, X.509 v3 certificates, and other 
# security standards. This is useful for implementing SSL and S/MIME or other Internet security standards into an application.


# Contents
# Installed Programs: certutil, nss-config, and pk12util
# Installed Libraries: libcrmf.a, libfreebl3.so, libfreeblpriv3.so, libnss3.so, libnssckbi.so, libnssckbi-testlib.so, libnssdbm3.so, libnsssysinit.so, libnssutil3.so, libpkcs11testmodule.so, libsmime3.so, libsoftokn3.so, and libssl3.so
# Installed Directories: /usr/include/nss

# Short Descriptions
# certutil - is the Mozilla Certificate Database Tool. It is a command-line utility that can create and modify the Netscape Communicator cert8.db and key3.db database files. It can also list, generate, modify, or delete certificates within the cert8.db file and create or change the password, generate new public and private key pairs, display the contents of the key database, or delete key pairs within the key3.db file
# nss-config - is used to determine the NSS library settings of the installed NSS libraries
# pk12util - is a tool for importing certificates and keys from pkcs #12 files into NSS or exporting them. It can also list certificates and keys in such files

if [[ -f ../$(basename $PATCH_NSS) ]]; then
	patch -Np1 -i ../$(basename $PATCH_NSS)
fi

cd nss

make BUILD_OPT=1                      	\
	NSPR_INCLUDE_DIR=/usr/include/nspr  \
	USE_SYSTEM_ZLIB=1                   \
	ZLIB_LIBS=-lz                       \
	NSS_ENABLE_WERROR=0                 \
	$([ $(uname -m) = x86_64 ] && echo USE_64=1) \
	$([ -f /usr/include/sqlite3.h ] && echo NSS_USE_SYSTEM_SQLITE=1)
  
# BUILD_OPT=1: This option is passed to make so that the build is performed with no debugging symbols built into the binaries and the default compiler optimizations are used.
# NSPR_INCLUDE_DIR=/usr/include/nspr: This option sets the location of the nspr headers.
# USE_SYSTEM_ZLIB=1: This option is passed to make to ensure that the libssl3.so library is linked to the system installed zlib instead of the in-tree version.
# ZLIB_LIBS=-lz: This option provides the linker flags needed to link to the system zlib.
# $([ $(uname -m) = x86_64 ] && echo USE_64=1): The USE_64=1 option is required on x86_64, otherwise make will try (and fail) to create 32-bit objects. The [ $(uname -m) = x86_64 ] test ensures it has no effect on a 32 bit system.
# ([ -f /usr/include/sqlite3.h ] && echo NSS_USE_SYSTEM_SQLITE=1): This tests if sqlite is installed and if so it echos the option NSS_USE_SYSTEM_SQLITE=1 to make so that libsoftokn3.so will link against the system version of sqlite.
# NSS_DISABLE_GTESTS=1: If you don't need to run NSS test suite, append this option to make command, to prevent the compilation of tests and save some build time.

if $RUN_TESTS; then
	cd tests
	HOST=localhost DOMSUF=localdomain ./all.sh
	cd ..
fi

# As Root:
cd ../dist

install -v -m755 Linux*/lib/*.so              /usr/lib
install -v -m644 Linux*/lib/{*.chk,libcrmf.a} /usr/lib

install -v -m755 -d                           /usr/include/nss
cp -v -RL {public,private}/nss/*              /usr/include/nss

install -v -m755 Linux*/bin/{certutil,nss-config,pk12util} /usr/bin

install -v -m644 Linux*/lib/pkgconfig/nss.pc  /usr/lib/pkgconfig

update_version_list $PKG_NSS
