# NSPR

# Netscape Portable Runtime (NSPR) provides a platform-neutral API for system level and libc like functions.
# Required for NSS

# Contents
# Installed Programs: nspr-config
# Installed Libraries: libnspr4.so, libplc4.so, and libplds4.so
# Installed Directories: /usr/include/nspr

# Short Descriptions
# nspr-config - provides compiler and linker options to other packages that use NSPR
# libnspr4.so - contains functions that provide platform independence for non-GUI operating system facilities such as threads, thread synchronization, normal file and network I/O, interval timing and calendar time, basic memory management and shared library linking
# libplc4.so - contains functions that implement many of the features offered by libnspr4
# libplds4.so - contains functions that provide data structures

cd nspr

sed -i '/^RELEASE/s|^|#|' pr/src/misc/Makefile.in	# This sed disables installing two unneeded scripts.

sed -i 's|$(LIBRARY) ||'  config/rules.mk	# This sed disables installing the static libraries.

./configure --prefix=/usr   \
            --with-mozilla  \
            --with-pthreads \
            $([ $(uname -m) = x86_64 ] && echo --enable-64bit)
# --with-mozilla: This parameter adds Mozilla support to the libraries (required if you want to build any other Mozilla products and link them to these libraries).
# --with-pthreads: This parameter forces use of the system pthread library.
# --enable-64bit: The --enable-64bit parameter is required on an x86_64 system to prevent configure failing with a claim that this is a system without pthread support. The [ $(uname -m) = x86_64 ] test ensures it has no effect on a 32 bit system

make

# As Root:
make install

update_version_list $PKG_NSPR
