# libpwquality

# The libpwquality package provides common functions for password quality checking and also scoring them based on their apparent randomness. The library also provides a function for generating random passwords with good pronounceability.

# Contents
# Installed Programs: pwscore and pwmake
# Installed Libraries: pam_pwquality.so and libpwquality.so
# Installed Directories: pam_pwquality.so and libpwquality.so

# Short Descriptions
# pwmake - is a simple configurable tool for generating random and relatively easily pronounceable passwords
# pwscore - is a simple tool for checking quality of a password
# libpwquality.so - contains API functions for checking the password quality
# pam_pwquality.so - is a Linux PAM module used to perform password quality checking

./configure --prefix=/usr                      \
            --disable-static                   \
            --with-securedir=/usr/lib/security \
            --disable-python-bindings
# --disable-python-bindings: This parameter disables building Python bindings with the deprecated python3 setup.py build command. The explicit instruction to build the Python 3 binding with the pip3 wheel command is provided.

make
pip3 wheel -w dist --no-build-isolation --no-deps --no-cache-dir $PWD/python

# As Root:

make install &&
pip3 install --no-index --find-links=dist --no-cache-dir --no-user pwquality

# Configuring libpwquality
# libpwquality is intended to be a functional replacement for the now-obsolete pam_cracklib.so PAM module. To configure the system to use the pam_pwquality module, execute the following commands as the root user:

if [ ! -d /etc/pam.d ]; then
	mkdir -p /etc/pam.d
fi

if [ -f /etc/pam.d/system-password ]; then
	mv /etc/pam.d/system-password /etc/pam.d/system-password.archive-$(date +'%Y%m%d%H%M')
fi
# mv /etc/pam.d/system-password{,.orig} &&
cat > /etc/pam.d/system-password << "EOF"
# Begin /etc/pam.d/system-password

# check new passwords for strength (man pam_pwquality)
password  required    pam_pwquality.so   authtok_type=UNIX retry=1 difok=1 \
                                         minlen=8 dcredit=0 ucredit=0 \
                                         lcredit=0 ocredit=0 minclass=1 \
                                         maxrepeat=0 maxsequence=0 \
                                         maxclassrepeat=0 gecoscheck=0 \
                                         dictcheck=1 usercheck=1 \
                                         enforcing=1 badwords="" \
                                         dictpath=/usr/lib/cracklib/pw_dict

# use yescrypt hash for encryption, use shadow, and try to use any
# previously defined authentication token (chosen password) set by any
# prior module.
password  required    pam_unix.so        yescrypt shadow try_first_pass

# End /etc/pam.d/system-password
EOF

update_version_list $PKG_LIBPWQUALITY
