# CrackLib

# The CrackLib package contains a library used to enforce strong passwords by comparing user selected passwords to words in chosen word lists.
# There are additional word lists available for download, e.g., from https://wiki.skullsecurity.org/index.php/Passwords. CrackLib can utilize as many, or as few word lists you choose to install.

# Contents
# Installed Programs: cracklib-check, cracklib-format, cracklib-packer, cracklib-unpacker, cracklib-update, and create-cracklib-dict
# Installed Libraries: libcrack.so and the _cracklib.so (Python module)
# Installed Directories: /usr/lib/cracklib, /usr/share/dict and /usr/share/cracklib

# Short Descriptions
# cracklib-check - is used to determine if a password is strong
# cracklib-format - is used to format text files (lowercases all words, removes control characters and sorts the lists)
# cracklib-packer - creates a database with words read from standard input
# cracklib-unpacker - displays on standard output the database specified
# create-cracklib-dict - is used to create the CrackLib dictionary from the given word list(s)
# libcrack.so - provides a fast dictionary lookup method for strong password enforcement

./configure --prefix=/usr    \
            --disable-static \
            --with-default-dict=/usr/lib/cracklib/pw_dict
# --with-default-dict=/usr/lib/cracklib/pw_dict: This parameter forces the installation of the CrackLib dictionary to the /lib hierarchy.
# --disable-static: This switch prevents installation of static versions of the libraries.

make

make install

install -v -m644 -D    ../$(basename $PKG_CRACKLIB_WORDS) \
                         /usr/share/dict/cracklib-words.xz
# install -v -m644 -D ...: This command creates the /usr/share/dict directory (if it doesn't already exist) and installs the compressed word list there.

[ -f /usr/share/dict/cracklib-words.xz ] && rm -f /usr/share/dict/cracklib-words
unxz -v                  /usr/share/dict/cracklib-words.xz

[ -L /usr/share/dict/words ] && unlink /usr/share/dict/words
ln -v -sf cracklib-words /usr/share/dict/words
# ln -v -s cracklib-words /usr/share/dict/words: The word list is linked to /usr/share/dict/words as historically, words is the primary word list in the /usr/share/dict directory. Omit this command if you already have a /usr/share/dict/words file installed on your system.

echo $HOSTNAME >>      /usr/share/dict/cracklib-extra-words
# echo $(hostname) >>...: The value of hostname is echoed to a file called cracklib-extra-words. This extra file is intended to be a site specific list which includes easy to guess passwords such as company or department names, user names, product names, computer names, domain names, etc.

install -v -m755 -d      /usr/lib/cracklib

create-cracklib-dict     /usr/share/dict/cracklib-words \
                         /usr/share/dict/cracklib-extra-words
# create-cracklib-dict ...: This command creates the CrackLib dictionary from the word lists. Modify the command to add any additional word lists you have installed.


if $RUN_TESTS
then
    set +e
    make check
    set -e
fi

# If you are installing CrackLib after your LFS system has been completed and you have the Shadow package installed, you must reinstall Shadow-4.16.0 if you wish to provide strong password support on your system. 
# If you are now going to install the Linux-PAM-1.6.1 package, you may disregard this note as Shadow will be reinstalled after the Linux-PAM installation.

update_version_list $PKG_CRACKLIB
