DESCRIPTION="The Low Level Virtual Machine (LLVM) Core libraries provide a modern source and target-independent optimizer."

EXT_VERSION=$(basename $PKG_LLVM .src.tar.xz | cut -d "-" -f 2)

unset CPLUS_INCLUDE_PATH
#CPLUS_INCLUDE_PATH=/usr/include/c++/15.2.0/x86_64-pc-linux-gnu/:/usr/include/c++/15.2.0/:/usr/include

tar -xf ../$(basename $PKG_CMAKE_MOD_LLVM)
tar -xf ../$(basename $PKG_DEP_LLVM)
sed "/LLVM_COMMON_CMAKE_UTILS/s@../cmake@cmake-$EXT_VERSION.src@" -i CMakeLists.txt
sed "/LLVM_THIRD_PARTY_DIR/s@../third-party@third-party-$EXT_VERSION.src@" -i cmake/modules/HandleLLVMOptions.cmake

tar -xf ../$(basename $PKG_CLANG) -C tools
mv tools/$(basename $PKG_CLANG .tar.xz) tools/clang

tar -xf ../$(basename $PKG_RT) -C projects
mv projects/$(basename $PKG_RT .tar.xz) projects/compiler-rt

grep -rl '#!.*python' | xargs sed -i '1s/python$/python3/'

sed 's/utility/tool/' -i utils/FileCheck/CMakeLists.txt

mkdir -v build
cd       build

OPTION=""
OPTION2=""
if [[ $(command -v dot) != "" ]]; then
	[[ $(command -v doxygen) != "" ]] && OPTION="-D LLVM_ENABLE_DOXYGEN=true" || OPTION=""
	[[ $(command -v sphinx-apidoc) != "" ]] && OPTION2="-D LLVM_ENABLE_SPHINX=true" || OPTION2=""
fi

GCC15=""
GXX15=""
#[ $(gcc -dumpversion | cut -d "." -f 1) == 15 ] && GCC15="-std=gnu++17" && GXX15="-std=c++17"
#[ $(gcc -dumpversion | cut -d "." -f 1) == 15 ] && GCC15="-std=gnu++20" && GXX15="-std=c++20"
#[ $(gcc -dumpversion | cut -d "." -f 1) == 15 ] && GCC15="-std=gnu++23" && GXX15="-std=c++23"

CC="gcc $GCC15" CXX="g++ $GXX15"  			 \
cmake -D CMAKE_INSTALL_PREFIX=/usr           \
      -D CMAKE_SKIP_INSTALL_RPATH=ON         \
      -D LLVM_ENABLE_FFI=ON                  \
      -D CMAKE_BUILD_TYPE=Release            \
      -D LLVM_BUILD_LLVM_DYLIB=ON            \
      -D LLVM_LINK_LLVM_DYLIB=ON             \
      -D LLVM_ENABLE_RTTI=ON                 \
      -D LLVM_TARGETS_TO_BUILD="host;AMDGPU;BPF" \
      -D LLVM_BINUTILS_INCDIR=/usr/include   \
      -D LLVM_INCLUDE_BENCHMARKS=OFF         \
      -D CLANG_DEFAULT_PIE_ON_LINUX=ON       \
      -D CLANG_CONFIG_FILE_SYSTEM_DIR=/etc/clang \
	  -D LLVM_ENABLE_PIC=ON \
      $OPTION $OPTION2 -Wno-warning_flag -G Ninja ..

#-D LLVM_ENABLE_PIC=ON
# -- Looking for malloc/malloc.h
# -- Looking for malloc/malloc.h - not found
# -- Looking for mach/mach.h
# -- Looking for mach/mach.h - not found
# -- Looking for CrashReporterClient.h
# -- Looking for CrashReporterClient.h - not found
ninja

if [[ $(command -v dot) != "" ]]; then	#graphviz
	#[[ $OPTION != "" ]] && ninja doxygen-llvm
	#/var/local/extension/sources/llvm/build/tools/clang/docs/doxygen/html
	#pushd tools/clang/docs/
		#doxygen doxygen.cfg
	#popd
	#ninja doxygen-llvm
	#ninja doxygen-clang
	#ninja docs-clang-man
	#ninja docs-llvm-man
	#-D LLVM_BUILD_DOCS
	echo ""
	#[[ $OPTION2 != "" ]] && docs-lld-html
fi

# sed -e 's/config.has_no_default_config_flag/True/' \
    # -e 's/"-fuse-ld=gold"//'                       \
    # -i ../projects/compiler-rt/test/lit.common.cfg.py

# tests
#systemctl   --user start dbus
#systemd-run --user --pty -d -G -p LimitCORE=0 ninja check-all

# As root:
ninja install

if $MULTILIB
then
	rm -rf *
	CC=gcc CXX=g++                                          \
	cmake -D CMAKE_INSTALL_PREFIX=/usr                      \
		  -D CMAKE_C_FLAGS:STRING=-m32                      \
		  -D CMAKE_SKIP_INSTALL_RPATH=ON                    \
		  -D CMAKE_CXX_FLAGS:STRING=-m32                    \
		  -D LLVM_TARGET_ARCH:STRING=i686                   \
		  -D LLVM_LIBDIR_SUFFIX=32                          \
		  -D LLVM_ENABLE_FFI=ON                             \
		  -D CMAKE_BUILD_TYPE=Release                       \
		  -D LLVM_BUILD_LLVM_DYLIB=ON                       \
		  -D LLVM_LINK_LLVM_DYLIB=ON                        \
		  -D LLVM_ENABLE_RTTI=ON                            \
		  -D LLVM_DEFAULT_TARGET_TRIPLE="i686-pc-linux-gnu" \
		  -D LLVM_TARGETS_TO_BUILD="X86;host;AMDGPU;NVPTX"  \
		  -D LLVM_HOST_TRIPLE="x86_64-pc-linux-gnu"         \
		  -D LLVM_BINUTILS_INCDIR=/usr/include              \
		  -D LLVM_INCLUDE_BENCHMARKS=OFF                    \
		  -D CLANG_DEFAULT_PIE_ON_LINUX=ON                  \
		  -D CLANG_CONFIG_FILE_SYSTEM_DIR=/etc/clang        \
		  -W no-dev -G Ninja .. 

	ninja
	
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	rm -rf *
	# CC=gcc CXX=g++											\
	# cmake -D CMAKE_INSTALL_PREFIX=/usr						\
		  # -D CMAKE_C_FLAGS="-mx32"							\
		  # -D CMAKE_SKIP_INSTALL_RPATH=ON					\
		  # -D CMAKE_CXX_FLAGS="-mx32"						\
		  # -D LLVM_TARGET_ARCH="x86_64"						\
		  # -D LLVM_LIBDIR_SUFFIX=x32							\
		  # -D LLVM_BUILD_32_BITS=On							\
		  # -D LLVM_ENABLE_FFI=ON								\
		  # -D CMAKE_BUILD_TYPE=Release						\
		  # -D LLVM_BUILD_LLVM_DYLIB=ON						\
		  # -D LLVM_LINK_LLVM_DYLIB=ON						\
		  # -D LLVM_ENABLE_RTTI=ON							\
		  # -D LLVM_DEFAULT_TARGET_TRIPLE="x86_64-pc-linux-gnux32" \
		  # -D LLVM_TARGETS_TO_BUILD="host"					\
		  # -D LLVM_HOST_TRIPLE="x86_64-pc-linux-gnu"         \
		  # -D LLVM_BINUTILS_INCDIR=/usr/include              \
		  # -D LLVM_INCLUDE_BENCHMARKS=OFF                    \
		  # -D CLANG_DEFAULT_PIE_ON_LINUX=ON                  \
		  # -D CLANG_CONFIG_FILE_SYSTEM_DIR=/etc/clang        \
		  # -W no-dev -G Ninja .. 
	# ninja


	rm -rf *
	# CC=gcc CXX=g++											\
	# cmake -D CMAKE_INSTALL_PREFIX=/usr						\
		  # -D CMAKE_C_FLAGS="-mx32"							\
		  # -D CMAKE_CXX_FLAGS="-mx32"						\
		  # -D LLVM_TARGET_ARCH="x86_64"						\
		  # -D LLVM_LIBDIR_SUFFIX=x32							\
		  # -D CMAKE_BUILD_TYPE=Release						\
		  # -D LLVM_DEFAULT_TARGET_TRIPLE="x86_64-pc-linux-gnux32" \
		  # -D LLVM_TARGETS_TO_BUILD="X86"					\
		  # -D LLVM_HOST_TRIPLE="x86_64-pc-linux-gnu"         \
		  # -D LLVM_BINUTILS_INCDIR=/usr/include              \
		  # -D CLANG_CONFIG_FILE_SYSTEM_DIR=/etc/clang        \
		  # -W no-dev -G Ninja .. 
	# ninja
	# [2524/5807]
	# /usr/bin/ld: i386:x86-64 architecture of input file `libx32/libLLVMSupport.a(blake3_sse2_x86-64_unix.S.o)' is incompatible with i386:x64-32 output
	# /usr/bin/ld: i386:x86-64 architecture of input file `libx32/libLLVMSupport.a(blake3_sse41_x86-64_unix.S.o)' is incompatible with i386:x64-32 output
	# /usr/bin/ld: i386:x86-64 architecture of input file `libx32/libLLVMSupport.a(blake3_avx2_x86-64_unix.S.o)' is incompatible with i386:x64-32 output
	# /usr/bin/ld: i386:x86-64 architecture of input file `libx32/libLLVMSupport.a(blake3_avx512_x86-64_unix.S.o)' is incompatible with i386:x64-32 output
	# -D LLVM_BUILD_32_BITS=On							\
	# -mno-avx2 -mno-avx -mno-avx512f -mno-sse4.1 -mno-sse4.2 X86;host;AMDGPU;NVPTX
	
	# DESTDIR=$PWD/DESTDIR ninja install
	# cp -vr DESTDIR/usr/libx32/* /usr/libx32
	# rm -rf DESTDIR 
	# ldconfig	
fi

mkdir -pv /etc/clang
for i in clang clang++; do
  echo -fstack-protector-strong > /etc/clang/$i.cfg
done

update_version_list $PKG_LLVM
