DESCRIPTION="The Linux PAM package contains Pluggable Authentication Modules used by the local system administrator to control how application programs authenticate users."

EXT_VERSION=$(basename $PKG_LINUX_PAM .tar.xz | cut -d "-" -f 3) 

#OPTIONS="-D docdir=/usr/share/doc/Linux-PAM-$EXT_VERSION"
#[[ $(cat /etc/xml/catalog | grep 5.0) == "" ]] && OPTIONS="-D docs=disabled"
OPTIONS="-D docs=disabled"

# General setup --->
  # [*] Auditing support                                                   [AUDIT]

[ -d /etc/security ] && cp -r /etc/security /etc/security-$(date +%Y%m%d%H%M)
[ -d /etc/environment ] && cp -r /etc/environment /etc/environment-$(date +%Y%m%d%H%M)
[ -d /etc/pam.d ] && cp -r /etc/pam.d /etc/pam.d-$(date +%Y%m%d%H%M)

sed -e "s/'elinks'/'lynx'/"                       \
    -e "s/'-no-numbering', '-no-references'/      \
          '-force-html', '-nonumbers', '-stdin'/" \
    -i meson.build

mkdir build
cd    build

meson setup ..        \
  --prefix=/usr       \
  --buildtype=release \
  $OPTIONS

#../doc/man/meson.build:42:2: ERROR: Command `/usr/bin/xmllint --nonet --noout --xinclude 
#--relaxng http://docbook.org/xml/5.0/rng/docbookxi.rng misc_conv.3.xml` failed with status 5.


ninja

# As root:
install -v -m755 -d /etc/pam.d

# if [ ! -f /etc/pam.d/other ]; then
# cat > /etc/pam.d/other << "EOF"
# auth     required       pam_deny.so
# account  required       pam_deny.so
# password required       pam_deny.so
# session  required       pam_deny.so
# EOF
# fi

# rm -fv /etc/pam.d/other

ninja install
chmod -v 4755 /usr/sbin/unix_chkpwd

tar -C / -xvf ../../$(basename $DOC_LINUX_PAM)

if $MULTILIB
then
	rm -rf *
	# export CFLAGS="-m32"
	# export LDFLAGS="-m32"
	CC="gcc -m32" CXX="g++ -m32"         	\
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig	\
	meson setup .. 							\
				--prefix=/usr 				\
				--libdir=/usr/lib32			\
				--buildtype=release			\
				-D docs=disabled
	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	rm -rf *
	# export CFLAGS="-mx32"
	# export LDFLAGS="-mx32"
	CC="gcc -mx32" CXX="g++ -mx32"         		\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig		\
	meson setup .. 								\
				--prefix=/usr 					\
				--libdir=/usr/libx32			\
				--buildtype=release				\
				-D docs=disabled
	ninja
	DESTDIR=$PWD/DESTDIR ninja install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 
	ldconfig	
fi

install -vdm755 /etc/pam.d &&

cat > /etc/pam.d/system-account << "EOF" &&
# Begin /etc/pam.d/system-account

account   required    pam_unix.so

# End /etc/pam.d/system-account
EOF

cat > /etc/pam.d/system-auth << "EOF" &&
# Begin /etc/pam.d/system-auth

auth      required    pam_unix.so

# End /etc/pam.d/system-auth
EOF

cat > /etc/pam.d/system-session << "EOF" &&
# Begin /etc/pam.d/system-session

session   required    pam_unix.so

# End /etc/pam.d/system-session
EOF

cat > /etc/pam.d/system-password << "EOF"
# Begin /etc/pam.d/system-password

# use yescrypt hash for encryption, use shadow, and try to use any
# previously defined authentication token (chosen password) set by any
# prior module.
password  required    pam_unix.so       yescrypt shadow try_first_pass

# End /etc/pam.d/system-password
EOF

cat > /etc/pam.d/other << "EOF"
# Begin /etc/pam.d/other

auth        required        pam_warn.so
auth        required        pam_deny.so
account     required        pam_warn.so
account     required        pam_deny.so
password    required        pam_warn.so
password    required        pam_deny.so
session     required        pam_warn.so
session     required        pam_deny.so

# End /etc/pam.d/other
EOF

echo "Rebuilding Shadow"
extension --install shadow --rebuild
echo "Finshed Rebuilding of Shadow"

echo "Rebuilding SystemD"
extension --install systemd --rebuild
echo "Finshed Rebuilding of SystemD"

update_version_list linux_pam-$EXT_VERSION
