DESCRIPTION="The Linux Kernel"

KERNELVERS=$(basename $PKG_LINUX .tar.xz | cut -d "-" -f 2) 

CONFIGFILE=config-$KERNELVERS

make mrproper

if [[ $(command -v clang) == "" ]]; then
	cp ../$(basename $PKG_CONFIGFILE) .config
	#make menuconfig
else
	cp ../$(basename $PKG_CONFIGRUST) .config
fi

make
make modules_install
make headers_install

cp .config /boot/$CONFIGFILE
cp arch/x86_64/boot/bzImage /boot/vmlinuz-$KERNELVERS
cp System.map /boot/System.map-$KERNELVERS

install -d /usr/share/doc/linux-$KERNELVERS
cp -r Documentation/* /usr/share/doc/linux-$KERNELVERS

chmod 0755 /usr/sbin/mkinitramfs
mkinitramfs $KERNELVERS && cp initrd.img-$KERNELVERS /boot/


update_version_list $PKG_LINUX
