DESCRIPTION="The libxslt package contains XSLT libraries used for extending libxml2 libraries to support XSLT files."
# libxslt
# The libxslt package contains XSLT libraries used for extending libxml2 libraries to support XSLT files.

# Contents
# Installed Programs: xslt-config and xsltproc
# Installed Libraries: libexslt.so, libxslt.so and optionally, libxsltmod.so Python module
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/libexslt, /usr/include/libxslt, /usr/lib/cmake/libxslt, /usr/lib/libxslt-plugins, /usr/share/gtk-doc/lib{xslt,exslt}, /usr/share/doc/libxslt-1.1.42, and /usr/share/doc/libxslt-python-1.1.42

# Short Descriptions
# xslt-config - is used to find out the pre-processor, linking and compiling flags necessary to use the libxslt libraries in 3rd-party programs
# xsltproc - is used to apply XSLT stylesheets to XML documents
# libexslt.so - is used to provide extensions to XSLT functions
# libxslt.so - provides extensions to the libxml2 libraries to parse files that use the XSLT format

# Required
# libxml2-2.13.6

# Recommended
# None

# Recommended_Runtime
# docbook-xml-4.5 and docbook-xsl-nons-1.79.2

# Optional
# libgcrypt-1.11.0

# Optional_Documentation
# None

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_LIBXSLT .tar.xz | cut -d "-" -f 2)

./configure --prefix=/usr                          \
            --disable-static                       \
            --docdir=/usr/share/doc/libxslt-$EXT_VERSION &&
make

# As root:
make install

update_version_list $PKG_LIBXSLT
