DESCRIPTION="The libxml2 package contains libraries and utilities used for parsing XML files."
# libxml2
# The libxml2 package contains libraries and utilities used for parsing XML files.

# Contents
# Installed Programs: xml2-config, xmlcatalog, and xmllint
# Installed Libraries: libxml2.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/libxml2, /usr/lib/cmake/libxml2, /usr/share/doc/libxml2-2.13.6, and /usr/share/gtk-doc/html/libxml2

# Short Descriptions
# xml2-config - determines the compile and linker flags that should be used to compile and link programs that use libxml2
# xmlcatalog - is used to monitor and manipulate XML and SGML catalogs
# xmllint - parses XML files and outputs reports (based upon options) to detect errors in XML coding
# libxml2.so - provides functions for programs to parse files that use the XML format

# Required
# None

# Recommended
# ICU-76.1

# Optional
# None

# Optional_Documentation
# None

# Optional_Testing
# Valgrind-3.24.0 (may be used in the tests)

# Updating this package is known to break ABI.

EXT_VERSION=$(basename $PKG_LIBXML2 .tar.xz | cut -d "-" -f 2)

[[ $(command -v icu-config) != "" ]] && OPTIONS="--with-icu" || OPTIONS=""

./configure --prefix=/usr           \
            --sysconfdir=/etc       \
            --disable-static        \
            --with-history          \
            $OPTIONS              \
            PYTHON=/usr/bin/python3 \
            --docdir=/usr/share/doc/libxml2-$EXT_VERSION
make

#[[ -f ../$(basename $TEST_LIBXML2) ]] && tar xf ../$(basename $TEST_LIBXML2)

# As root:
make install

rm -vf /usr/lib/libxml2.la &&
sed '/libs=/s/xml2.*/xml2"/' -i /usr/bin/xml2-config

if $MULTILIB
then
	make distclean
	CC="gcc -m32" CXX="g++ -m32"         	\
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig	\
	./configure --prefix=/usr 				\
				--libdir=/usr/lib32      	\
				--host=i686-pc-linux-gnu 	\
				--sysconfdir=/etc        	\
				--disable-static         	\
				--with-history           	\
				--with-icu               	\
				--without-python
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	make distclean
	CC="gcc -mx32" CXX="g++ -mx32"         		\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig		\
	./configure --prefix=/usr 					\
				--libdir=/usr/libx32			\
				--host=x86_64-pc-linux-gnux32 	\
				--sysconfdir=/etc        		\
				--disable-static         		\
				--with-history           		\
				--with-icu               		\
				--without-python
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 
	ldconfig	
fi

update_version_list $PKG_LIBXML2
