DESCRIPTION="libxkbcommon is a keymap compiler and support library which processes a reduced subset of keymaps as defined by the XKB specification."
# libxkbcommon
# libxkbcommon is a keymap compiler and support library which processes a reduced subset of keymaps as defined by the XKB specification. 

# Contents
# Installed Programs: xkbcli
# Installed Libraries: libxkbcommon.so, libxkbcommon-x11.so, and libxkbregistry.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/xkbcommon, /usr/libexec/xkbcommon, and /usr/share/doc/libxkbcommon-1.8.0

# Short Descriptions
# xkbcli - provides a debugger and compiler for XKB keymaps
# libxkbcommon.so - contains the libxkbcommon API functions
# libxkbcommon-x11.so - contains the libxkbcommon X11 specific API functions
# libxkbregistry.so - contains a list of available XKB models, layouts, and variants for a given ruleset

# Required
# xkeyboard-config-2.44 (runtime)

# Recommended
# libxcb-1.17.0, Wayland-1.23.0, and wayland-protocols-1.40

# Recommended_Runtime
# None

# Optional
# Xvfb (from Xorg-Server-21.1.16 or Xwayland-24.1.6)

# Optional features and packages
# None

# Optional input plugins
# None

# Optional mux/demux plugins

# None

# Optional codec plugins
# None

# Optional video plugins
# None

# Optional audio plugins
# None

# Optional interface plugins
# None

# Optional visualisations and video filter plugins
# None

# Optional service discovery plugins
# None

# Miscellaneous options
# None

# Optional_Documentation
# Doxygen-1.13.2

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_LIBXKBCOMMON .tar.gz | cut -d "-" -f 2) 

mkdir build &&
cd    build &&

if [[ $(command -v doxygen) ]]; then
	meson setup ..             \
		  --prefix=/usr        \
		  --buildtype=release  \
		  -D enable-docs=true
	ninja
else
	meson setup ..             \
		  --prefix=/usr        \
		  --buildtype=release  \
		  -D enable-docs=false
	ninja
fi

# As root:
ninja install
[ -d /usr/share/doc/libxkbcommon{,-$EXT_VERSION} ] && rm -r /usr/share/doc/libxkbcommon{,-$EXT_VERSION}
[[ $(command -v doxygen) ]] && mv -v /usr/share/doc/libxkbcommon{,-$EXT_VERSION}

update_version_list $PKG_LIBXKBCOMMON
