DESCRIPTION="The Xorg libraries provide library routines that are used within all X Window applications."
# Xorg Libraries
# The Xorg libraries provide library routines that are used within all X Window applications.

# Contents
# Installed Programs: cxpm and sxpm
# Installed Libraries: libfontenc.so, libFS.so, libICE.so, libpciaccess.so, libSM.so, libX11.so, libX11-xcb, libXaw6.so, libXaw7.so, libXaw.so, libXcomposite.so, libXcursor.so, libXdamage.so, libXext.so, libXfixes.so, libXfont2.so, libXft.so, libXinerama.so, libXi.so, libxkbfile.so, libXmu.so, libXmuu.so, libXpm.so, libXpresent.so, libXrandr.so, libXrender.so, libXRes.so, libxshmfence.so, libXss.so, libXt.so, libXtst.so, libXvMC.so, libXvMCW.so, libXv.so, libXxf86dga.so and libXxf86vm.so
# Installed Directory: $XORG_PREFIX/include/X11/fonts, $XORG_PREFIX/include/X11/ICE, $XORG_PREFIX/include/X11/SM, $XORG_PREFIX/include/X11/Xmu, $XORG_PREFIX/include/X11/Xtrans, $XORG_PREFIX/share/doc/libFS, $XORG_PREFIX/share/doc/libICE-1.1.2, $XORG_PREFIX/share/doc/libSM-1.2.6, $XORG_PREFIX/share/doc/libX11-1.8.12, $XORG_PREFIX/share/doc/libXaw, $XORG_PREFIX/share/doc/libXext, $XORG_PREFIX/share/doc/libXi, $XORG_PREFIX/share/doc/libXmu-1.2.1, $XORG_PREFIX/share/doc/libXrender, $XORG_PREFIX/share/doc/libXt, $XORG_PREFIX/share/doc/libXtst, $XORG_PREFIX/share/doc/libXvMC, $XORG_PREFIX/share/doc/xtrans and $XORG_PREFIX/share/X11/locale

# Short Descriptions
# cxpm - checks the format of an XPM file
# sxpm - shows an XPM file and/or converts XPM 1 or 2 files to XPM 3
# libfontenc.so - is the X11 font encoding library
# libFS.so - is the library interface to the X Font Server
# libICE.so - is the X Inter Client Exchange Library
# libpciaccess.so - is the generic PCI Access library for X
# libSM.so - is the X Session Management Library
# libX11.so - is the Xlib Library
# libXaw6.so - is the X Athena Widgets Library, version 6
# libXaw7.so - is the X Athena Widgets Library, version 7
# libXaw.so - are symbolic links to the current X Athena Widgets Library, version 7
# libXcomposite.so - is the X Composite Library
# libXcursor.so - is the X Cursor management library
# libXdamage.so - is the X Damage Library
# libXext.so - is the Misc X Extension Library
# libXfixes.so - provides augmented versions of core protocol requests
# libXfont2.so - is the X font library
# libXft.so - is the X FreeType interface library
# libXinerama.so - is the Xinerama Library
# libXi.so - is the X Input Extension Library
# libxkbfile.so - is the xkbfile Library
# libXmu.so - is the X interface library for miscellaneous utilities not part of the Xlib standard
# libXmuu.so - is the Mini Xmu Library
# libXpm.so - is the X Pixmap Library
# libXpresent.so - is the library interface to the X Present Extension
# libXrandr.so - is the X Resize, Rotate and Reflection extension library
# libXrender.so - is the X Render Library
# libXRes.so - is the X-Resource extension client library
# libxshmfence.so - exposes an event API on top of Linux futexes
# libXss.so - is the X11 Screen Saver extension client library
# libXt.so - is the X Toolkit Library
# libXtst.so - is the Xtst Library
# libXvMC.so - is the X-Video Motion Compensation Library
# libXvMCW.so - is the XvMC Wrapper including the Nonstandard VLD extension
# libXv.so - is the X Window System video extension library
# libXxf86dga.so - is the client library for the XFree86-DGA extension
# libXxf86vm.so - is the client library for the XFree86-VidMode X extension

# Required
# Fontconfig-2.16.0 and libxcb-1.17.0

# Optional
# asciidoc-10.2.1, xmlto-0.0.29 with one or more of the following: fop-2.10, Links-2.30, Lynx-2.9.2, ncompress (for some tests), and W3m (to generate additional PDF or text documentation for the libXfont package).

# Recommended at runtime
# dbus-1.16.0

[[ ! -f /etc/profile.d/xorg.sh ]] && echo "Installing xorg_build_env" && extension --install xorg_build_env && echo "Finished xorg_build_env"
source /etc/profile.d/xorg.sh

# First, start a subshell that will exit on error:
# bash -e

# Install all of the packages by running the following commands:

package=$PKG_LIBXFT
docdir="--docdir=/usr/share/doc/$(basename ${package%.tar.?z*})"
  
./configure $XORG_CONFIG $docdir

make
#make check 2>&1 | tee ../$packagedir-make_check.log

make install

/sbin/ldconfig

if $MULTILIB
then
	make clean
	CC="gcc -m32" CXX="g++ -m32"            \
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig	\
	./configure $XORG_CONFIG $docdir		\
				--libdir=/usr/lib32			\
				--host=i686-pc-linux-gnu
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR
	/sbin/ldconfig
fi
if $MULTILIB_X32	
then
	make clean
	CC="gcc -mx32" CXX="g++ -mx32"          \
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig	\
	./configure $XORG_CONFIG $docdir		\
				--libdir=/usr/libx32		\
				--host=x86_64-pc-linux-gnux32
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR
	/sbin/ldconfig
fi

update_version_list $PKG_LIBXFT
