DESCRIPTION="The libXdmcp package contains a library implementing the X Display Manager Control Protocol."
# libXdmcp
# The libXdmcp package contains a library implementing the X Display Manager Control Protocol. This is useful for allowing clients to interact with the X Display Manager.

# Contents
# Installed Programs: hb-info, hb-ot-shape-closure, hb-shape, hb-subset, and hb-view (only if Cairo is installed)
# Installed Libraries: libharfbuzz.so, libharfbuzz-cairo.so (only if Cairo is installed), libharfbuzz-gobject.so, libharfbuzz-icu.so, and libharfbuzz-subset.so
# Installed DRI Driver Stubs: None
# Installed VA-API Drivers: None
# Installed GBM Backends: None
# Installed VDPAU Drivers: None
# Installed Vulkan Drivers: None
# Installed Directories: /usr/include/harbuzz, /usr/lib/cmake/harfbuzz, and /usr/share/gtk-doc/html/harfbuzz (optional)

# Short Descriptions
# comparerender - is a test and benchmarking tool
# gr2fonttest - is a diagnostic console tool for graphite fonts
# libgraphite2.so - is a rendering engine for graphite fonts

# Required
# xorgproto-2024.1

# Recommended
# None

# Recommended_Runtime
# None

# Optional
# xmlto-0.0.29, fop-2.10, libxslt-1.1.42

# Optional_Documentation
# Xorg-SGML-doctools

# Optional_Testing
# None

EXT_VERSION=$(basename $PKG_LIBXDMCP .tar.xz | cut -d "-" -f 2) 

./configure $XORG_CONFIG --docdir=/usr/share/doc/libXdmcp-$EXT_VERSION &&
make

# As root:
make install

if $MULTILIB
then
	make distclean 
	CC="gcc -m32" CXX="g++ -m32" 			\
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig 	\
	./configure $XORG_CONFIG --libdir=/usr/lib32
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	make distclean
	CC="gcc -mx32" CXX="g++ -mx32"         		\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig		\
	./configure $XORG_CONFIG --libdir=/usr/libx32
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/libx32/* /usr/libx32
	rm -rf DESTDIR 
	ldconfig	
fi

update_version_list $PKG_LIBXDMCP
