DESCRIPTION="libxcvt is a library providing a standalone version of the X server implementation of the VESA CVT standard timing modelines generator."

EXT_VERSION=$(basename $PKG_LIBXCVT .tar.xz | cut -d "-" -f 2) 

mkdir build &&
cd    build &&

meson setup --prefix=$XORG_PREFIX --buildtype=release .. &&
ninja

# As root:
ninja install

if $MULTILIB
then
	rm -rf *
	CC="gcc -m32" CXX="g++ -m32"         \
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig \
	meson setup --prefix=/usr            \
				--libdir=/usr/lib32      \
				--buildtype=release      \
				..

	ninja
	DESTDIR=$PWD/DESTDIR ninja install 
	cp -vr DESTDIR/usr/lib32/* /usr/lib32 
	rm -rf DESTDIR 
	ldconfig
fi
if $MULTILIB_X32
then
	rm -rf *
	CC="gcc -mx32" CXX="g++ -mx32" 			\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig	\
	meson setup --prefix=/usr				\
				--libdir=/usr/libx32		\
				--buildtype=release			\
				..

	ninja
	DESTDIR=$PWD/DESTDIR ninja install 
	cp -vr DESTDIR/usr/libx32/* /usr/libx32 
	rm -rf DESTDIR 
	ldconfig
fi

update_version_list $PKG_LIBXCVT
