DESCRIPTION="The Libxcrypt package contains a modern library for one-way hashing of passwords."

EXT_VERSION=$(basename $PKG_LIBXCRYPT .tar.xz | cut -d "-" -f 2) 

./configure --prefix=/usr                \
            --enable-hashes=strong,glibc \
            --enable-obsolete-api=no     \
            --disable-static             \
            --disable-failure-tokens

make

# if $RUN_TESTS
# then
    # set +e
    # make check
    # set -e
# fi

make install

if $MULTILIB
then
	#32 bit
	make distclean
	
	CC="gcc -m32" CXX="g++ -m32"         	\
	PKG_CONFIG_PATH=/usr/lib32/pkgconfig	\
	./configure --prefix=/usr                \
				--host=i686-pc-linux-gnu     \
				--libdir=/usr/lib32          \
				--enable-hashes=strong,glibc \
				--enable-obsolete-api=glibc  \
				--disable-static             \
				--disable-failure-tokens
	
	make
	make DESTDIR=$PWD/DESTDIR install
	cp -vr DESTDIR/usr/lib32/* /usr/lib32
	rm -rf DESTDIR 
	libtool --finish /usr/lib32
	ldconfig
	make install-pkgconfigDATA &&
	ln -svf libxcrypt.pc /usr/lib32/pkgconfig/libcrypt.pc
fi
if $MULTILIB_X32
then	
	#x32bit
	make distclean
	
	CC="gcc -m32" CXX="g++ -m32"         	\
	PKG_CONFIG_PATH=/usr/libx32/pkgconfig	\
	./configure --prefix=/usr                 \
				--host=x86_64-pc-linux-gnux32 \
				--libdir=/usr/libx32          \
				--enable-hashes=strong,glibc  \
				--enable-obsolete-api=glibc   \
				--disable-static              \
				--disable-failure-tokens
				
	make
	
	cp -av .libs/libcrypt.so* /usr/libx32/ &&
	make install-pkgconfigDATA &&
	ln -svf libxcrypt.pc /usr/libx32/pkgconfig/libcrypt.pc
fi

update_version_list libxcrypt-$EXT_VERSION
